import React, { useEffect, useState } from 'react';
import { SafeAreaView, View, Text, StyleSheet, FlatList, TextComponent } from 'react-native';
import calApi from './db/calendarInfo.api';

const DetailItem = ({ item }) => {
  return (
    <>{
      item != [] ? <View style={{
        flexDirection: "row", padding: "5%", borderColor: '#d3d3d3', //light grey
        borderWidth: 1, borderTopWidth: 0,
      }}>
        <Text style={item.type === 1 ? style.inputColor : style.outputColor}>{item.category}</Text>
        <Text style={[style.itemText, style.Font]}>{item.contents}</Text>
        <Text style={[style.itemText, style.Font]}>{item.price}원</Text>
      </View> : <View>
        <Text>내역이 없습니다.</Text>
      </View>
    }

    </>
  );
};

const DetailInfo = ({ route }) => {
  console.log('route', route.params)
  console.log('---------------------------')
  const [resData, setResData] = useState([])
  const getDetailData = async () => {
    try {
      const resdata = await calApi.detailData({ findDate: route.params })
      console.log('resdata', resdata)
      setResData(resdata)
    } catch (error) {
      console.log('error in getDetailData', error)
    }
  }
  const renderDetail = ({ item }) => {
    return (
      <DetailItem item={item} />
    )
  }
  useEffect(() => {
    getDetailData()
  }, [])
  return (
    <>
      <SafeAreaView>
        <FlatList
          data={resData}
          renderItem={renderDetail}
          keyExtractor={item => item.id}
        />
      </SafeAreaView>
    </>
  )
}
const style = StyleSheet.create({
  Font: {
    fontSize: 20,
    color: '#424242'
  },
  inputColor: {
    color: '#1E90FF'
  },
  outputColor: {
    color: '#dc143c'
  },
  itemText: {
    paddingRight: "10%",
    paddingLeft: "20%",
    // alignItems:"center"
  }
});

export default DetailInfo;