import React from 'react';
import { StyleSheet, Text, View, TextInput } from 'react-native';

const InputBox = (props) => {
    return (
        <View style={style.container}>
            <View style={style.inputTitleArea}>
                <Text style={style.inputTitle}>{props.inputTitle}</Text>
            </View>
            <TextInput
                underlineColorAndroid="transparent"
                placeholder={props.placeholder}
                placeholderTextColor="#808080"
                keyboardType={props.keyboardType}
                onChangeText={props.onChangeText}
                returnKeyType={props.returnKeyType}
                numberOfLines={props.numberOfLines}
                multiline={props.multiline}
                onSubmitEditing={props.onSubmitEditing}
                style={style.textStyle}
                blurOnSubmit={false}
                value={props.value}
            />
        </View>
    );
};

const style = StyleSheet.create({
    container: {
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
        borderWidth: 1.5,
        borderStyle: "solid",
        borderColor: "#1467ff",
        borderRadius: 5,
        backgroundColor: "#f5f5f5",
    },
    inputTitleArea: {
        flex: 1,
    },
    inputTitle: {
        alignSelf: "center",
        color: "#1467ff",
        fontSize: 20,
    },
    textStyle: {
        flex: 3,
        fontSize: 20,
    },
})

export default InputBox