import React, { useState } from 'react';
import { StyleSheet, View, Text, Button, Pressable, TouchableWithoutFeedback, Keyboard } from 'react-native';
import { globalStyles } from '../styles/global';
import InputBox from '../components/InputBox';
import StyledButton from '../components/StyledButton';


function MemoDetails({ route }) {
    const [date, setDate] = useState('')
    const [person, setPerson] = useState('')
    const [money, setMoney] = useState('')


    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={{ flex: 1 }}>
                <View>
                    <InputBox
                        inputTitle="날짜"
                        placeholder={route.params?.date}
                        onChangeText={
                            (date) => setDate(date)
                        }
                    />
                    <InputBox
                        inputTitle="내용"
                        placeholder={route.params?.person}
                        onChangeText={
                            (person) => setPerson(person)
                        }
                    />
                    <InputBox
                        inputTitle="금액"
                        placeholder={route.params?.money}
                        onChangeText={
                            (money) => setMoney(moeny)
                        }
                    />
                </View>
                <View style={style.buttonRow}>
                    <StyledButton
                        name="수정"
                        onPress={() => console.log('수정버튼')}
                        style={style.submitButton}
                    />
                    <StyledButton
                        name="저장"
                        onPress={() => console.log('취소버튼')}
                        style={style.cancelButton}
                    />
                </View>
            </View>
        </TouchableWithoutFeedback>
    )
}



const style = StyleSheet.create({

    buttonRow: {
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
    },
    submitButton: {
        flex: 1,
        height: 50,
    },
    cancelButton: {
        flex: 1,
        height: 50,
    }
});




export default MemoDetails;