import React, { useEffect, useState } from 'react';
import { StyleSheet, View, Text, Button, Pressable, TouchableWithoutFeedback, Keyboard } from 'react-native';
import { globalStyles } from '../styles/global';
import InputBox from '../components/InputBox';
import StyledButton from '../components/StyledButton';


function InfoDetails({ route }) {
    const [date, setDate] = useState('')
    const [person, setPerson] = useState('')
    const [money, setMoney] = useState('')
    const [remained_money, setRemained_money] = useState('')
    useEffect(() => {
        setDate(route.params?.date)
        setPerson(route.params?.person)
        setMoney(route.params?.money)
        setRemained_money(route.params?.remained_money)
    }, [])

    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={{ flex: 1 }}>
                <View>
                    <InputBox
                        inputTitle="날짜"
                        value={date}
                        onChangeText={
                            (date) => setDate(date)
                        }
                    />
                    <InputBox
                        inputTitle="누구에게"
                        value={person}
                        onChangeText={
                            (person) => setPerson(person)
                        }
                    />
                    <InputBox
                        inputTitle="금액"
                        value={money}
                        onChangeText={
                            (money) => setMoney(money)
                        }
                    />
                    <InputBox
                        inputTitle="남은 금액"
                        value={remained_money}
                        onChangeText={
                            (remaied_money) => setRemained_money(remained_money)
                        }
                    />
                </View>
                <View style={style.buttonRow}>
                    <StyledButton
                        name="수정"
                        onPress={() => console.log('수정버튼')}
                        style={style.submitButton}
                    />
                    <StyledButton
                        name="저장"
                        onPress={() => console.log('취소버튼')}
                        style={style.cancelButton}
                    />
                </View>
            </View>
        </TouchableWithoutFeedback>
    )
}



const style = StyleSheet.create({

    buttonRow: {
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
    },
    submitButton: {
        flex: 1,
        height: 50,
    },
    cancelButton: {
        flex: 1,
        height: 50,
    }
});




export default InfoDetails;