import React from 'react';
import { StyleSheet, Button, TextInput, View, Text, TouchableWithoutFeedback, Keyboard } from 'react-native';
import { globalStyles } from '../styles/global.js'
import { Formik } from 'formik';
import * as yup from 'yup';

const ReviewSchema = yup.object({
    date: yup.string() //string만 받는다
        .required()  //아무것도 입력안했하면 안받음
        .min(4),  //최소4글짜
    person: yup.string()
        .required()
        .min(2),
    money: yup.string()
        .required(),
    remained_money: yup.string()
        .required()
})




function InfoForm({ addInfo }) {
    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={globalStyles.container} >
                <Formik
                    initialValues={{ date: '', person: '', money: '', remained_money: '' }}
                    validationSchema={ReviewSchema}
                    onSubmit={(values) => {//위의 4개의 val들을 전달

                        addInfo(values);
                    }}

                >

                    {({ handleChange, handleSubmit, values }) => (
                        <View>
                            <TextInput
                                style={globalStyles.input}
                                placeholder='날짜'
                                onChangeText={handleChange('date')} //우리가 바꾸려는 val
                                value={values.date}
                            />

                            <TextInput
                                style={globalStyles.input}
                                placeholder='누구에게'
                                onChangeText={handleChange('person')}
                                value={values.person}
                            />

                            <TextInput
                                style={globalStyles.input}
                                placeholder='금액'
                                onChangeText={handleChange('money')}
                                value={values.money}
                                keyboardType='numeric'
                            />

                            <TextInput
                                style={globalStyles.input}
                                placeholder='남은 금액'
                                onChangeText={handleChange('remained_money')}
                                value={values.remained_money}
                                keyboardType='numeric'
                            />

                            <Button title='입력' color='maroon' onPress={handleSubmit} />
                        </View>
                    )}

                </Formik>

            </View >
        </TouchableWithoutFeedback>
    )
}

export default InfoForm;