import React from 'react';
import { Button, View, TouchableWithoutFeedback, Keyboard } from 'react-native';
import { globalStyles } from '../styles/global.js'
import { Formik } from 'formik';
import * as yup from 'yup';
import DatePicker from '../components/DatePicker.js';
import InputBox from '../components/InputBox';
import { getDateStr } from '../utils/dateFunction';

const ReviewSchema = yup.object({
    date: yup.string()
        .required(),
    message: yup.string()
        .required()
        .min(2),
    money: yup.number()
        .required(),
    repayment: yup.number()
        .required()
})

function DeptForm({ addInfo }) {
    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={globalStyles.container} >
                <Formik
                    initialValues={{ date: getDateStr(), message: '', money: '', repayment: '' }}
                    validationSchema={ReviewSchema}
                    onSubmit={(values) => {
                        addInfo(values);
                    }}
                >
                    {({ handleChange, handleSubmit, values }) => (
                        <View>
                            <DatePicker
                                inputTitle='날짜'
                                date={values.date}
                                setDate={handleChange('date')}
                            />
                            <InputBox
                                inputTitle="내용"
                                onChangeText={handleChange('message')}
                                value={values.message}
                            />
                            <InputBox
                                inputTitle="원금"
                                onChangeText={handleChange('money')}
                                value={values.money}
                                keyboardType="numeric"
                            />
                            <InputBox
                                inputTitle="갚은 금액"
                                onChangeText={handleChange('repayment')}
                                value={values.repayment}
                                keyboardType="numeric"
                            />

                            <View style={{ marginVertical: '10%', marginHorizontal: 10 }}>
                                <Button title='입력' color='dodgerblue' onPress={handleSubmit} />
                            </View>

                        </View>
                    )}
                </Formik>
            </View >
        </TouchableWithoutFeedback>
    )
}

export default DeptForm;