import React, { useEffect, useRef } from 'react';
import { Animated, Text, View, StyleSheet } from 'react-native';

const NotificationBox = (props) => {
    const opacity = useRef(new Animated.Value(0)).current;

    useEffect(() => {
        Animated.sequence([
            Animated.timing(opacity, {
                toValue: 1,
                duration: 500,
            }),
            Animated.delay(2500),
            Animated.timing(opacity, {
                toValue: 0,
                duration: 500,
            }),
        ]).start(() => {
            props.onHide();
        })
    }, [])

    return (
        <Animated.View
            style={[
                {
                    opacity: opacity
                },
                {
                    transform: [{
                        translateY: opacity.interpolate({
                            inputRange: [0, 1],
                            outputRange: [-20, 0],
                        })
                    }],
                },
                style.msgBox
            ]}
        >
            <Text style={style.textStyle}>
                {props.message}
            </Text>
        </Animated.View>
    );
};

const Notification = (props) => {
    return (
        <View style={{
            position: 'absolute',
            top: 0,
            left: 0,
            right: 0,
        }}>
            {console.log(props.notification)}
            {props.notification.map((notificationMsg) => (
                <NotificationBox
                    key={notificationMsg}
                    message={notificationMsg}
                    onHide={() => {
                        props.setNotification((prev) =>
                        prev.filter((currentNotification) => currentNotification !== notificationMsg )
                    )
                    }}
                />
            ))}
        </View>
    )
}

const style = StyleSheet.create({
    msgBox: {
        margin: 10,
        marginBottom: 5,
        backgroundColor: 'white',
        padding: 15,
        borderRadius: 4,
        shadowColor: 'black',
        shadowOffset: {
            width: 0,
            height: 3,
        },
        shadowOpacity: 0.3,
        shadowRadius: 5,
        elevation: 6,
    },
    textStyle: {
        fontSize: 20
    }
})

export default Notification