import React, { useState } from 'react';
import { Text, View, StyleSheet, Pressable } from 'react-native';
import AntDesign from 'react-native-vector-icons/AntDesign';

const Accordion = ({
    title,
    left,
    right,
    children,
    titleStyle = style.text,
    backgroundColor = 'lightgray',
}) => {
    const [opened, setOpened] = useState(false);

    const handleOpen = () => { setOpened(!opened) };

    return (
        <View>
            <View>
                <Pressable
                    style={[style.flexRow, style.catBox, { backgroundColor: backgroundColor }]}
                    onPress={handleOpen}
                >
                    <View style={[style.flexRow, style.flexCenter]}>
                        {left ? left : null}
                        <Text style={titleStyle}>
                            {title}
                        </Text>
                    </View>
                    <View style={[style.flexRow, style.flexCenter]}>
                        {right ? right : null}
                        <AntDesign
                            name={opened ? 'caretup' : 'caretdown'}
                            color='black'
                            size={24}
                            style={style.rightIcon}
                        />
                    </View>
                </Pressable>
            </View>

            {opened ?
                children
                : null}
        </View>
    )
};

export const AccordionItem = ({
    title,
    left,
    right,
    titleStyle = style.text,
    backgroundColor = 'lightgray',
    marginLeft = 20,
}) => {
    return (
        <View style={[style.flexRow, style.flexCenter, style.catBox, { backgroundColor: backgroundColor }]}>
            <View style={[style.flexRow, style.flexCenter, { marginLeft: marginLeft }]}>
                {left ? left : null}
                <Text style={titleStyle}>
                    {title}
                </Text>
            </View>
            {right ? right : null}
        </View>
    );
};

const style = StyleSheet.create({
    flexRow: {
        flexDirection: 'row',
    },
    flexCenter: {
        justifyContent: 'center',
        alignItems: 'center',
    },
    catBox: {
        justifyContent: 'space-between',
        paddingVertical: 10,
    },
    rightIcon: {
        marginHorizontal: 5,
        fontSize: 20,
        color: 'black',
    },
    text: {
        fontSize: 20,
        marginHorizontal: 10,
    },
})

export default Accordion