import React from 'react';
import { Button, View, TouchableWithoutFeedback, Keyboard } from 'react-native';
import { globalStyles } from '../styles/global.js'
import { Formik } from 'formik';
import * as yup from 'yup';
import DatePicker from '../components/DatePicker.js';
import InputBox from '../components/InputBox.js';
import { getDateStr } from '../utils/dateFunction';

const ReviewSchema = yup.object({
    date: yup.string()
        .required(),
    message: yup.string()
        .required()
        .min(2),

})

function MemoForm({ addInfo }) {
    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={globalStyles.container} >
                <Formik
                    initialValues={{ date: getDateStr(), message: '' }}
                    validationSchema={ReviewSchema}
                    onSubmit={(values) => {
                        addInfo(values);
                    }}

                >
                    {({ handleChange, handleSubmit, values }) => (
                        <View>
                            <DatePicker
                                inputTitle='날짜'
                                date={values.date}
                                setDate={handleChange('date')}
                            />
                            <InputBox
                                inputTitle="내용"
                                onChangeText={handleChange('message')}
                                value={values.message}

                            />
                            <View style={{ marginVertical: '10%', marginHorizontal: 10 }}>
                                <Button title='입력' color='dodgerblue' onPress={handleSubmit} />
                            </View>
                        </View>
                    )}

                </Formik>

            </View >
        </TouchableWithoutFeedback>
    )
}

export default MemoForm;