import React from 'react';
import { StyleSheet, Pressable, Text } from 'react-native';

const StyledButton = ({
    name,
    onPress,
    style,
    disabled, 
}) => {
    return (
        <Pressable
            style={({ pressed }) => [
                {
                    backgroundColor: disabled ? '#9c9c9c' : pressed ? '#adbfdb' : '#bfd3f2',
                },
                styles.pressableStyle,
                style
            ]}
            onPress={onPress}
            disabled={disabled}>
            <Text style={styles.buttonText}>{name}</Text>
        </Pressable>
    );
};

const styles = StyleSheet.create({
    pressableStyle: {
        alignItems: "center",
        justifyContent: "center",
        marginRight: 3,
        borderRadius: 2,
    },
    buttonText: {
        fontFamily: 'GowunDodum-Regular',
        fontSize: 20,
    },
})

export default StyledButton
