import React, {  useState, useEffect } from 'react';
import { View,  StyleSheet } from 'react-native';
import CalendarStrip from 'react-native-calendar-strip';

const WeeklyCalendar = ({
    selectedDate,
    startingDate,
    onWeekChanged,
    onDateSelected,
    weeklyData = [],
    customDatesStyles
}) => {
    const [markedDates, setmarkedDates] = useState([])
    
    useEffect(() => {
        getMarkedDates()
    }, [weeklyData])

    const getMarkedDates = () => {
        if(weeklyData.length === 0) {
            return null;
        }

        const markedData = weeklyData.map(data => {
            return (
                {
                    date: data.date,
                    dots: getDots(data.type_id)
                }
            );
        })

        setmarkedDates(markedData)
    }

    const getDots = (typeArray) => {
        const tempDots = []
        for (let i = 0; i < typeArray.length; i++) {
            if (typeArray[i] === "1") {
                tempDots.push({ color: "#93bdcc", selectedColor: "#7b9e7c", })
            } else {
                tempDots.push({ color: "#d98b79", })
            }
        }
        return tempDots;
    }

    return (
        <View>
            <CalendarStrip
                calendarAnimation={{ type: 'parallel', duration: 30 }}
                daySelectionAnimation={{ type: 'background', duration: 300, highlightColor: '#9265DC' }}
                style={{ height: 130, paddingTop: 20, paddingBottom: 10 }}
                calendarHeaderStyle={{ color: 'white' }}
                calendarColor={'#adbfdb'}
                dateNumberStyle={{ color: 'white' }}
                dateNameStyle={{ color: 'white' }}
                iconContainer={{ flex: 0.1 }}
                customDatesStyles={customDatesStyles}
                updateWeek
                highlightDateNameStyle={{ color: 'white' }}
                highlightDateNumberStyle={{ color: 'white' }}
                highlightDateContainerStyle={{ backgroundColor: '#6b768a' }}
                // markedDates={markedDates}
                // datesBlacklist={datesBlacklistFunc}
                // startingDate={startingDate}
                selectedDate={selectedDate}
                onWeekChanged={onWeekChanged}
                onDateSelected={onDateSelected}
                useIsoWeekday={false}
            />
        </View>
    );
};

const style = StyleSheet.create({
    container: {
        height: 54,
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
        borderWidth: 1.5,
        borderStyle: "solid",
        borderColor: "#1467ff",
        borderRadius: 5,
        backgroundColor: "#f5f5f5",
    },
})

export default WeeklyCalendar