import React, { useState, useEffect } from 'react';
import { View, StyleSheet } from 'react-native';
import InputBox from './components/InputBox';
import ButtonsForm from './components/ButtonsForm';
import SelectForm from './components/SelectForm';
import StyledButton from './components/StyledButton';
import DatePicker from './components/DatePicker';
import moneyApi from './db/postMoney.api';
import updateApi from './db/updatePage.api';

const INIT_ASSETSTYPE = {
  id: 1,
  value: '',
}

const INIT_CATEGORY = {
  id: 1,
  value: '',
}

const INIT_SUBCATEGORY = {
  id: 1,
  value: '',
  foreign_id: 0,
}


function updatePage({ navigation, route }) {
  const [selectedIndex, setSelectedIndex] = useState(route.params[1].type - 1)
  const [date, setDate] = useState(route.params[0])
  const [contents, setContents] = useState(route.params[1].contents)
  const [price, setPrice] = useState(`${route.params[1].price}`)
  const [asset_type, setAsset_type] = useState([])
  const [selected_asset_type, setSelected_asset_type] = useState(INIT_ASSETSTYPE)
  const [selected_deposit_asset_type, setSelected_deposit_asset_type] = useState(INIT_ASSETSTYPE)
  const [categories, setCategories] = useState([])
  const [selected_cat, setSelected_cat] = useState(INIT_CATEGORY)
  const [subcategories, setSubcategories] = useState([])
  const [selected_subcat, setSelected_subcat] = useState(INIT_SUBCATEGORY)

  const [success, setSuccess] = useState(false)

  useEffect(() => {
    loadCat()
    loadSubCat()
    loadAssetType()
    initData()
  }, [selectedIndex])


  const initData = () => {
    setSelected_asset_type(INIT_ASSETSTYPE)
    setSelected_cat(INIT_CATEGORY)
    setSelected_subcat(INIT_SUBCATEGORY)
  }

  const loadCat = async () => {
    try {
      const catArray = await moneyApi.selectCategories(selectedIndex + 1)
      setCategories(catArray);
    } catch (error) {
      console.log('error in load categories ( postMoney.js )', error)
    }
  }

  const loadSubCat = async () => {
    try {
      const subCatArray = await moneyApi.selectSubCategories()
      setSubcategories(subCatArray);
    } catch (error) {
      console.log('error in load categories ( postMoney.js )', error)
    }
  }

  const loadAssetType = async () => {
    try {
      const assetsTypeArray = await moneyApi.selectAssetsType()
      setAsset_type(assetsTypeArray);
    } catch (error) {
      console.log('error in load assets type ( postMoney.js )', error)
    }
  }

  const deleteData = async () => {
    try {
      if (selectedIndex === 2){
        await updateApi.delData({ findId: [route.params[1].id, route.params[1].id+1] })
      } else {
        await updateApi.delData({ findId: [route.params[1].id] })
      }
      initData()
      setSuccess(true)
    } catch (error) {
      console.log('error in deleteData', error)
    }
  }

  const changeData = async () => {
    try {
      if(selectedIndex===2){
        await updateApi.updateData({ findId: route.params[1].id }, [date, contents, -price, selected_cat.id, selected_subcat.id, selected_asset_type.id, selectedIndex + 1])
        await updateApi.updateData({ findId: route.params[1].id+1 }, [date, contents, price, selected_cat.id, selected_subcat.id,  selected_deposit_asset_type.id, selectedIndex + 1])
      } else {
        await updateApi.updateData({ findId: route.params[1].id }, [date, contents, price, selected_cat.id, selected_subcat.id, selected_asset_type.id, selectedIndex + 1])
      }
      setSuccess(true)
    } catch (error) {
      console.log('error in change Data', error)
    }
  }

  const onUpdateCatPress = () => {
    navigation.navigate('EditOption', selectedIndex + 1)
  }

  const onUpdateAssetPress = () => {
    navigation.navigate('EditOption', 0)
  }

  if (success) {
    navigation.goBack()
  }
  return (
    <View>
      <View>
        {selectedIndex === 2 ? null : <ButtonsForm
          onPress={(index) => setSelectedIndex(index)}
          selectedIndex={selectedIndex}
          group={["수입", "지출"]} />}

        <DatePicker
          inputTitle="날짜"
          date={date}
          setDate={setDate}
        />
        <InputBox
          inputTitle="내용"
          value={contents}
          onChangeText={
            (contents) => setContents(contents)
          }
          maxLength={30}
        />
        <InputBox
          inputTitle="금액"
          value={price}
          onChangeText={
            (price) => setPrice(price)
          }
          keyboardType="numeric"
          maxLength={30}
        />
        <SelectForm
          inputTitle={selectedIndex === 2 ? "출금" : "자산"}
          placeholder="자산 선택"
          data={asset_type}
          selectedData={selected_asset_type}
          onValueChange={(asset) => setSelected_asset_type(asset)}
          onUpdateDataPress={onUpdateAssetPress}
        />
        {selectedIndex === 2 &&
          <SelectForm
            inputTitle="입금"
            placeholder="자산 선택"
            data={asset_type}
            selectedData={selected_deposit_asset_type}
            onValueChange={(deposit_asset) => setSelected_deposit_asset_type(deposit_asset)}
            onUpdateDataPress={onUpdateAssetPress}
          />}
        <SelectForm
          inputTitle="구분"
          placeholder="카테고리 선택"
          data={categories}
          selectedData={selected_cat}
          onValueChange={(cat) => setSelected_cat(cat)}
          subData={subcategories}
          selectedSubData={selected_subcat}
          onSubValueChange={(subcat) => setSelected_subcat(subcat)}
          onUpdateDataPress={onUpdateCatPress}
        />
      </View>
      <View style={style.buttonRow}>
        <StyledButton
          name="저장"
          onPress={changeData}
          style={style.submitButton}
        />
        <StyledButton
          name="삭제"
          onPress={deleteData}
          style={style.delButton}
        />
        <StyledButton
          name="취소"
          onPress={() => navigation.goBack()}
          style={style.cancelButton}
        />
      </View>
    </View>
  )
};

const style = StyleSheet.create({
  Font: {
    fontSize: 24
  },
  buttonRow: {
    flexDirection: 'row',
    alignItems: "center",
    marginHorizontal: 10,
    marginVertical: 3,
  },
  submitButton: {
    flex: 2,
    height: 50,
  },
  delButton: {
    flex: 1,
    height: 50,
  },
  cancelButton: {
    flex: 1,
    height: 50,
  }
});

export default updatePage;