import React, { useState, useEffect } from 'react';
import { View, Text, StyleSheet, FlatList, TouchableOpacity } from 'react-native';

const INIT_Data = [
  {
    date: "2021-06-30",
    type: { 'input': 50000, 'output': 3500 },
  },
  {
    date: "2021-07-01",
    type: { 'input': 100000, 'output': 2000 },
  },
  {
    date: "2021-07-05",
    type: { 'input': 15000, 'output': 2010 },
  },
  {
    date: "2021-07-10",
    type: { 'input': 10000, 'output': 1000 },
  },
];

const DateItem = ({ dateitem, textColor, onPress, flatListHeight }) => {
  return (
    <TouchableOpacity onPress={onPress}
      style={[style.dateContainer]}>
      <Text style={textColor}>{dateitem.date.getDate()}</Text>
      {
        dateitem.type &&
        <View>
          <Text style={{ color: '#1E90FF' }}>{dateitem.type.input ? dateitem.type.input : null}</Text>
          <Text style={{ color: '#DC143C' }}>{dateitem.type.output ? dateitem.type.output : null}</Text>
        </View>
      }
    </TouchableOpacity>
  );
};

const Montly = () => {
  // const [flatListHeight, setFlatListHeight] = useState(400)

  const temp = [];
  for (let i = 0; i < 12; i++) {
    temp.push({ date: new Date(2021, 6, i) })
  }

  console.log('temp', temp[0].date)

  const DBDates = [];
  for (let i = 0; i < INIT_Data.length; i++) {
    // console.log('날짜만 가져오기', INIT_Data[i].date, 'index', i)
    const str = INIT_Data[i].date
    DBDates.push({ date: new Date(Number(str.slice(0, 4)), Number(str.slice(5, 7)) - 1, Number(str.slice(8, 10))), type: INIT_Data[i].type })

  }
  // console.log('DBDates', DBDates)

  for (let i = 0; i < temp.length; i++) {
    const idx = DBDates.findIndex(obj => obj.date.getTime() == temp[i].date.getTime())
    if (idx !== -1) {
      temp[i] = DBDates[idx]
    }
  }

  console.log('reTemp', temp)
  //reTemp 30


  // const date3 = new Date(2021, 6, 1);
  // const dy = date3.getFullYear();
  // const dm = ('0' + (date3.getMonth() + 1)).slice(-2);
  // const dd = ('0' + date3.getDate()).slice(-2);
  // ;
  // // console.log('eachValue', dy, dm, dd)
  
  const renderDate = ({ item }) => {
    // let color = '#000000';
    // if (item.datesVal.getDate() === date.getDate() && month === todayM && year === todayY) {
    //   istoday = true;
    // }
    // if (istoday) {
    //   color = '#6495ed'
    //   istoday = false;
    // }
    // if (!(item.datesVal.getMonth() === month)) {
    //   color = '#a9a9a9'
    // }
    return (
      <DateItem dateitem={item} />
    )
  }

  // const onLayout = (event) => {
  //   const { x, y, height, width } = event.nativeEvent.layout;
  //   setFlatListHeight(height)
  // }
  return (
    <>
      <View>
        <Text style={style.Font}>여기는 월별 페이지</Text>
        <Text style={style.Font}>달력을 추가할 예정입니다.</Text>
      </View>
      <FlatList
        data={temp}
        numColumns={7}
        renderItem={renderDate}
        keyExtractor={item => item.date}
      />
    </>

  )
}
const style = StyleSheet.create({
  Font: {
    fontSize: 24
  }
});

export default Montly;