import React from 'react';
import { StyleSheet, Text, View } from 'react-native';
import Ionicons from 'react-native-vector-icons/Ionicons';

function TodoItem({ item, onDeleteHandle }) {
    return (
        <View style={styles.item}>
            <Ionicons name='trash-outline' size={15} color='#333' onPress={onDeleteHandle} />
            <Text style={styles.itemText}>{item.date}</Text>
            <Text style={styles.itemText}>{item.message}</Text>
            <Text style={styles.itemText}>{item.money}</Text>
            <Text style={styles.itemText}>{item.remained_money}</Text>
        </View>

    )

}

const styles = StyleSheet.create({
    item: {
        padding: 16,
        marginTop: 16,
        borderColor: '#bbb',
        borderWidth: 1,
        borderStyle: 'd',
        borderStyle: 'dashed', 
        borderRadius: 10,
        flexDirection: 'row' 
    },
    itemText: {
        fontFamily: 'GowunDodum-Regular',
        marginLeft: 10,
    }
})

export default TodoItem;