import React, {useState} from 'react';
import { View, Text, TextInput, StyleSheet, Button, Keyboard, TouchableWithoutFeedback, Modal } from 'react-native';
import { SpeedDial } from 'react-native-elements';
import WeeklyCalendar from './components/WeeklyCalendar';
import Ionicons from 'react-native-vector-icons/Ionicons';
import DeptPage from './DeptPage';

function MainScreen({ navigation }) {
    const [number, onChangeNumber] = useState(null);
    const [modalOpen, setModalOpen] = useState(false);
    const [open, setOpen] = useState(false)

    return (
        <>
            <TouchableWithoutFeedback onPress={() => {
                Keyboard.dismiss();
            }}>
                <View style={{ flex: 1 }}>
                    <WeeklyCalendar />

                    <View >
                        <Text style={style.Font}>여기는 메인 페이지 입니다.</Text>
                        <Text style={style.Font}>아래는 input 테스트를 위한 것입니다.</Text>
                        <TextInput
                            style={style.TextInput}
                            onChangeText={onChangeNumber}
                            keyboardType="numeric"
                        />
                        <Text>입력한 숫자 보기: {number} </Text>
                    </View>

                    <Button
                        title="월별 페이지로 이동"
                        onPress={() => navigation.navigate('Monthly')}
                    />
                    <SpeedDial
                        isOpen={open}
                        icon={{ name: 'edit', color: '#fff' }}
                        openIcon={{ name: 'close', color: '#fff' }} 
                        onOpen={() => setOpen(!open)}
                        onClose={() => setOpen(!open)}
                    >
                        <SpeedDial.Action
                            icon={{ name: 'add', color: '#fff' }}
                            title="부채"
                            onPress={() => navigation.navigate('DeptPage')}
                        />
                        <SpeedDial.Action
                            icon={{ name: 'add', color: '#fff' }}
                            title="메모"
                            onPress={() => navigation.navigate('MemoPage')}
                        />

                    </SpeedDial>
                    <Modal visible={modalOpen} animationType='slide'>
                        <View style={style.modalContent}>
                            <Ionicons
                                name='close'
                                color='red'
                                size={24}
                                style={{ ...style.modalToggle, ...style.modalClose }}
                                onPress={() => setModalOpen(false)}
                            />
                            <DeptPage />
                        </View>
                    </Modal>

                </View>
            </TouchableWithoutFeedback>
        </>
    )
}

const style = StyleSheet.create({
    TextInput: {
        borderColor: 'skyblue',
        height: 40,
        margin: 12,
        borderWidth: 1
    },
    Font: {
        fontFamily: 'GowunDodum-Regular',
        fontSize: 24
    },
    modalToggle: {

        padding: 10,
        borderRadius: 10,
        alignSelf: 'flex-start',
        marginTop: -40, //위치를 center로
    },
    modalClose: {
        alignSelf: 'center',
        alignItems: 'flex-start',
        marginTop: 150,
        marginBottom: 50,
    },
    modalContent: {
        flex: 1,
    },
    Contents: {
        justifyContent: "center",
        alignItems: "center",
        margin: 10
    }
});

export default MainScreen;