import React from 'react';
import { NavigationContainer } from '@react-navigation/native';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import { createStackNavigator } from '@react-navigation/stack';
import Ionicons from 'react-native-vector-icons/Ionicons';
import Monthly from './Monthly';
import Analy from './Analy';
import PostMoney from './PostMoney';
import MainScreen from './MainScreen';
import CalDetail from './CalDetail';
import DeptPage from './DeptPage';
import DeptDetails from './screens/DeptDetails';
import MemoPage from './MemoPage';
import MemoDetails from './screens/MemoDetails';
import EditOption from './EditOption';

const Tab = createBottomTabNavigator();
const Stack = createStackNavigator();

function Home() {
  return (
    <Tab.Navigator screenOptions={({ route }) => ({
      tabBarIcon: ({ focused, color, size }) => {
        let iconName;

        if (route.name === 'Main') {
          iconName = focused
            ? 'home'
            : 'home-outline';
        } else if (route.name === 'Monthly') {
          iconName = focused ? 'calendar' : 'calendar-outline';
        } else if (route.name === 'Analy') {
          iconName = focused ? 'bar-chart' : 'bar-chart-outline';
        }
        return <Ionicons name={iconName} size={size} color={color} />;
      },
    })}
      tabBarOptions={{
        activeTintColor: '#bfd3f2',
        inactiveTintColor: 'gray',
      }}>
      <Tab.Screen name="Main" component={MainScreen} />
      <Tab.Screen name="Monthly" component={Monthly} />
      <Tab.Screen name="Analy" component={Analy} />
      <Tab.Screen name="PostMoney" component={PostMoney} />
    </Tab.Navigator>
  )
}

function App() {
  return (
    <NavigationContainer>
      <Stack.Navigator screenOptions={{
        headerStyle: {
          backgroundColor: '#eee'
        },
        headerTitleStyle: {
          fontFamily: 'GowunDodum-Regular'
        },
        headerTitleAlign: 'center'
      }} >
        <Stack.Screen
          name="Home"
          component={Home}
          options={{ headerShown: false }} />
        <Stack.Screen
          name="DeptPage"
          component={DeptPage}
          options={{ title: "부채", headerStyle: { backgroundColor: '#bfd3f2' } }} />
        <Stack.Screen
          name="DeptDetails"
          component={DeptDetails}
          options={{ title: "상세정보" }} />
        <Stack.Screen
          name="MemoPage"
          component={MemoPage}
          options={{ title: "메모", headerStyle: { backgroundColor: '#bfd3f2' } }} />
        <Stack.Screen
          name="MemoDetails"
          component={MemoDetails}
          options={{ title: "상세내용" }} />
        <Stack.Screen
          name="CalDetail"
          component={CalDetail}
          options={{ title: "일일내역" }} />
        <Stack.Screen
          name="EditOption"
          component={EditOption}
          options={{ title: "편집" }}
        />
      </Stack.Navigator>
    </NavigationContainer>
  );
}

export default App;
