import React, { useState, useEffect } from 'react';
import { View, Text, StyleSheet, Dimensions } from 'react-native';
import {
  LineChart,
  BarChart,
  PieChart,
  ProgressChart,
  ContributionGraph,
  StackedBarChart
} from "react-native-chart-kit";
const screenWidth = Dimensions.get("window").width;
const screenHeight = Dimensions.get("window").height;
const data1 = [
  {
    name: "Seoul",
    population: 21500000,
    color: "rgba(131, 167, 234, 1)",
    legendFontColor: "#7F7F7F",
    legendFontSize: 15
  },
  {
    name: "Toronto",
    population: 2800000,
    color: "#d8bfd8",
    legendFontColor: "#7F7F7F",
    legendFontSize: 15
  },
  {
    name: "Beijing",
    population: 1276120,
    color: "#87ceeb",
    legendFontColor: "#7F7F7F",
    legendFontSize: 15
  },
  {
    name: "New York",
    population: 8538000,
    color: "#fff5ee",
    legendFontColor: "#7F7F7F",
    legendFontSize: 15
  },
  {
    name: "Moscow",
    population: 11920000,
    color: "#b0c4de",
    legendFontColor: "#7F7F7F",
    legendFontSize: 15
  }
];
const data2 = {
  labels: ["Jan", "Feb", "Mar", "April", "May", "June"],
  datasets: [
    {
      data: [20, 45, 28, 80, 99, 43]
    }
  ]
};

const Analy = () => {
  const chartConfig = {
    backgroundGradientFrom: "#abbcd6", //좌측 색
    backgroundGradientFromOpacity: 0.5, 
    backgroundGradientTo: "#E6DDC5", // 우측 색
    backgroundGradientToOpacity: 0.2,
    backgroundColor: "#ffffff", // 어디에 적용된건지 잘 모르겠음
    color: (opacity = 1) => `rgba(0, 93, 232, ${opacity})`, // data의 색상 계산할 때 사용하는 함수
    //color: (opacity = 1) => `rgba(255, 255, 255, ${opacity})`,
    strokeWidth: 2, // optional, default 3
    barPercentage: 0.5, // 그래프 width
    useShadowColorFromDataset: false,// optional, default is false
    //fillShadowGradient: 'blue',
    fillShadowGradientOpacity: 1, // 좀 더 진하게만 할 뿐 단색 설정은 못하는 것 같음

  };
  const [state, SetState] = useState([]);
  return (
    <View>
      <Text style={style.Font}>여기는 분석 페이지/ 차트 테스트</Text>
      <PieChart
        data={data1}
        width={screenWidth}
        height={screenHeight / 3} //그래프의 높이가 커지기만
        chartConfig={chartConfig}
        accessor={"population"}
        backgroundColor={"#ffffff"}
        // paddingLeft={"15"}
        // center={[10, 50]}
        absolute
      />
      <BarChart 
        //style={graphStyle}
        data={data2}
        width={screenWidth}
        height={screenHeight / 3}
        //yAxisLabel="$"
        chartConfig={chartConfig}
      //verticalLabelRotation={30}
      />
    </View>
  )
}
const style = StyleSheet.create({
  Font: {
    fontSize: 24
  }
});

export default Analy;