import React, { useState } from 'react';
import { StyleSheet, Text, View, FlatList, TouchableOpacity, Modal, Alert, TouchableWithoutFeedback, Keyboard } from 'react-native';
import TodoItem from './components/todoItem';
import InfoForm from './screens/InfoForm';
import Ionicons from 'react-native-vector-icons/Ionicons';
import InfoDetails from './screens/InfoDetails'
import ButtonsForm from './components/ButtonsForm'; 
import { TabView } from 'react-native-elements';


function DeptPage({ navigation }) {
  const [selectedIndex, setSelectedIndex] = useState(0)
  const [modallOpen, setModallOpen] = useState(false);
  const [todo, setTodo] = useState([
    { date: '7/10', person: 'Mark', money: '100만원', remained_money: '10만원남음', key: '1' },
    { date: '7/10', person: 'John', money: '100만원', remained_money: '10만원남음', key: '2' },
    { date: '7/10', person: 'Steve', money: '100만원', remained_money: '10만원남음', key: '3' }
]);
  const [todos, setTodos] = useState([
    { date: '7/10', person: '수빈이', money: '100만원', remained_money: '10만원남음', key: '1' },
    { date: '7/10', person: '수현이', money: '100만원', remained_money: '10만원남음', key: '2' },
    { date: '7/10', person: '가영이', money: '100만원', remained_money: '10만원남음', key: '3' }
  ]);

  const addInfo = (info) => {
    info.key = Math.random().toString(); //앞에 key를 받아올수있도록 생성
    setTodos((currentInfos) => {
      return [info, ...currentInfos]; //새로운 정보와 지금까지 정보를 합친다
    });
    setModallOpen(false); //modal이 보여지지 않게
  }

  const pressHandler = (key) => {
    setTodos((prevTodos) => {
      return prevTodos.filter(todo => todo.key != key);
    });
  }

  return (
    <TouchableWithoutFeedback onPress={() => {
      Keyboard.dismiss();
    }}>
      <View Style={style.container}>
        <ButtonsForm
          onPress={(index) => setSelectedIndex(index)}
          selectedIndex={selectedIndex}
          group={["빌려준금액", "빌린금액"]} />

        <View>
          <View style={{ width: '100%', height: '75%' }}>
            <TabView value={selectedIndex} onChange={setSelectedIndex} >
              <TabView.Item style={{ width: '100%', height: '100%' }}>
                <FlatList
                  data={todo}
                  renderItem={({ item }) => (
                    <TouchableOpacity onPress={() => navigation.navigate('InfoDetails', item)}>
                      <TodoItem item={item} pressHandler={pressHandler} />
                    </TouchableOpacity>
                  )}
                />
              </TabView.Item>
              <TabView.Item style={{ width: '100%', height: '100%' }}>
                <FlatList
                  data={todos}
                  renderItem={({ item }) => (
                    <TouchableOpacity onPress={() => navigation.navigate('InfoDetails', item)}>
                      <TodoItem item={item} pressHandler={pressHandler} />
                    </TouchableOpacity>
                  )}
                />
              </TabView.Item>
            </TabView>
          </View>
          <Ionicons
            name='add'
            size={24}
            style={style.modalToggle} //...은 중괄호를 풀어서 합치려고 이용함
            onPress={() => setModallOpen(true)}
          />
        </View>
        <View>
          <Modal visible={modallOpen} animationType='slide'>
            <View style={style.modalContent}>
              <Ionicons
                name='close'
                size={24}
                style={style.modalToggle}
                onPress={() => setModallOpen(false)}
              />
              <InfoForm addInfo={addInfo} />

            </View>
          </Modal>
        </View>
      </View> 
    </TouchableWithoutFeedback >
  );
}





const style = StyleSheet.create({
  container: {
    flex: 1,
    width: '100%',
  },
  modalToggle: {
    borderWidth: 1,
    borderColor: 'gray', //gray
    padding: 5,
    borderRadius: 10,
    alignSelf: 'center', //위치를 center로
  },

  modalContent: {
    flex: 1, //이후 유용한 키보드를 추가하려고 ex)dismissing keyboard
  },

  TextInput: {
    borderColor: 'skyblue',
    height: 40,
    margin: 12,
    borderWidth: 1
  },
  Font: {
    fontSize: 24
  }
});

export default DeptPage;
