import React, { useState } from "react";
import { Button, View, Text, StyleSheet, Pressable } from "react-native";
import DateTimePickerModal from "react-native-modal-datetime-picker";
import { getDateStr } from '../utils/dateFunction';

const DatePicker = (props) => {
    const [isDatePickerVisible, setDatePickerVisibility] = useState(false);

    const showDatePicker = () => {
        setDatePickerVisibility(true);
    };

    const hideDatePicker = () => {
        setDatePickerVisibility(false);
    };

    const handleConfirm = (date) => {
        console.log("A date has been picked: ", getDateStr(date));
        props.setDate(getDateStr(date))
        hideDatePicker();
    };

    return (
        <View style={style.container}>
            <View style={style.inputTitleArea}>
                <Text style={style.inputTitle}>{props.inputTitle}</Text>
            </View>
            <Pressable
                style={style.dateAreaStyle}
                onPress={showDatePicker}>
                <Text style={style.dateTextStyle}>{props.date}</Text>
            </Pressable>
            <DateTimePickerModal
                isVisible={isDatePickerVisible}
                mode="date"
                onConfirm={handleConfirm}
                onCancel={hideDatePicker}
            />
        </View>
    );
};

const style = StyleSheet.create({
    container: {
        height:54,
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
        borderWidth: 1.5,
        borderStyle: "solid",
        borderColor: "#1467ff",
        borderRadius: 5,
        backgroundColor: "#f5f5f5",
    },
    inputTitleArea: {
        flex: 1,
    },
    inputTitle: {
        alignSelf: "center",
        color: "#1467ff",
        fontSize: 20,
    },
    dateAreaStyle: {
        flex: 3,
    },
    dateTextStyle: {
        fontSize: 20,
    },

})

export default DatePicker