import { DEBUG, enablePromise } from 'react-native-sqlite-storage';
import getDb from './moneyDB'

DEBUG(true);
enablePromise(true);

const delData = async ({ findId }) => {
  const db = await getDb();
  let insertQeury = '';
  let queryData = findId;
  if (findId.length === 2) {
    insertQeury = `DELETE FROM money WHERE money_id in (?,?)`
  } else {
    insertQeury = `DELETE FROM money WHERE money_id in (?)`
  }
  return new Promise((res, rej) => {
    db.transaction((tx) => {
      tx.executeSql(insertQeury, queryData)
      res('삭제완료');
    })
  })
}

const updateData = async ({ findId }, changeData) => {
  const db = await getDb();
  let insertQeury = `UPDATE money SET date=?, contents=?, price=?, category_id=?, subcategory_id=?, assets_id=?, type_id=? WHERE money_id=${findId};`
  return new Promise((res, rej) => {
    db.transaction(async (tx) => {
      await tx.executeSql(insertQeury, changeData)
      res('수정완료');
    })
  })
}

const updateApi = {
  delData,
  updateData
}

export default updateApi;