import React, {useState} from 'react';
import {StyleSheet, Text, View, FlatList, Alert, TouchableWithoutFeedback, Keyboard} from 'react-native';
import Header from'./components/header';
import TodoItem from './components/todoItem';
import AddTodo from './components/addTodo';
import Sandbox from './components/sandbox';


export default function App5() {
    const [todos, setTodos] = useState([
        { text: 'buy coffee', key:'1'},
        { text: 'create an app', key: '2'},
        { text: 'play on the swithch', key: '3'}
    ]);

    const pressHandler = (key) => {
        setTodos((prevTodos) => {
            return prevTodos.filter(todo => todo.ket != key);
        });
    }

    const submitHandler = (text) => {
    
        if(text.length > 3){
         setTodos((prevTodos) => {
             return [
                 { text: text, key: Math.random().toString() },
                 ...prevTodos
                 ];
            });
        }else {
        Alert.alert('OOPs!' , 'Todos must be over 4 chars long', [
            {text: 'Understood', onPress: () => console.log('alert closed')}
        ]);
        }
    }

    return(
        // <Sandbox />
        <TouchableWithoutFeedback onPress ={() => {
            Keyboard.dismiss();
            console.log('dismissed keyboard');
        }}>
        <View Style = {styles.container}>
            <Header/>
            <View style = {styles.content}>
                <AddTodo submitHandler = {submitHandler} />
                <View style = {styles.list}>
                    <FlatList
                        data = {todos}
                        renderItem = {({ item }) => (
                            <TodoItem item={item} pressHandler = {pressHandler} />
                        )}
                    />
                </View>
            </View>
        </View>
        </TouchableWithoutFeedback>
    );
}

const styles = StyleSheet.create({
    container: {
        flex:1,
        backgroundColor: '#fff',
    },
    content: {
        padding: 40,
        backgroundColor: 'pink',
        
    },
    list: {
        marginTop: 20,
        backgroundColor: 'yellow',
    }
});