import * as React from 'react';
import { useState } from 'react';
import { StyleSheet, View, Text, TextInput, Button, Keyboard, TouchableWithoutFeedback, Modal } from 'react-native';
import { NavigationContainer } from '@react-navigation/native';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import Ionicons from 'react-native-vector-icons/Ionicons';
import Monthly from './Monthly';
import Analy from './Analy';
import MoneyDB from './MoneyDB';
import DeptPage from './DeptPage';
import InfoForm from './screens/infoForm';
import { SpeedDial } from 'react-native-elements';
import { StackRouter } from 'react-navigation';
import InfoDetails from './screens/InfoDetails';
import { createStackNavigator } from '@react-navigation/stack';
// import HomeStack from './routes/HomeStack';
// import MainScreen from './screens/MainScreen';







function MainScreen({ navigation }) {
  const [number, onChangeNumber] = useState(null);
  const [modalOpen, setModalOpen] = useState(false);
  // const [reviews, setReviews] = useState([
  //   { title: 'aa', rating: 5, body: 'bb', key: '1' },
  // ]);
  const [open, setOpen] = useState(false)


  return (

    <>
      <TouchableWithoutFeedback onPress={() => {
        Keyboard.dismiss();

      }}>
        <View style={{ flex: 1 }}>


          <View >
            <Text style={style.Font}>여기는 메인 페이지 입니다.</Text>
            <Text style={style.Font}>아래는 input 테스트를 위한 것입니다.</Text>
            <TextInput
              style={style.TextInput}
              onChangeText={onChangeNumber}
              keyboardType="numeric"
            />
            <Text>입력한 숫자 보기: {number} </Text>
          </View>

          <Button
            title="월별 페이지로 이동"
            onPress={() => navigation.navigate('Monthly')}
          />
          <SpeedDial
            isOpen={open}
            icon={{ name: 'edit', color: '#fff' }} //연필모양
            openIcon={{ name: 'close', color: '#fff' }} //x모양
            onOpen={() => setOpen(!open)}
            onClose={() => setOpen(!open)}
          >
            <SpeedDial.Action
              icon={{ name: 'add', color: '#fff' }}
              title="부채"
              onPress={() => navigation.navigate('DeptPage')}
            />
            <SpeedDial.Action
              icon={{ name: 'delete', color: '#fff' }}
              title="Delete"
              onPress={() => navigation.navigate('DeptPage')}
            />

          </SpeedDial>

        </View>

        {/* <MoneyDB /> */}



      </TouchableWithoutFeedback>
    </>
  )
}


const Tab = createBottomTabNavigator();
const Stack = createStackNavigator();


function Home() {
  return (
    <Tab.Navigator screenOptions={({ route }) => ({
      tabBarIcon: ({ focused, color, size }) => {
        let iconName;

        if (route.name === 'Main') {
          iconName = focused
            ? 'home'
            : 'home-outline';
        } else if (route.name === 'Monthly') {
          iconName = focused ? 'calendar' : 'calendar-outline';
        } else if (route.name === 'Analy') {
          iconName = focused ? 'bar-chart' : 'bar-chart-outline';
        }

        // You can return any component that you like here!
        return <Ionicons name={iconName} size={size} color={color} />;
      },
    })}
      tabBarOptions={{
        activeTintColor: 'tomato',
        inactiveTintColor: 'gray',
      }}>
      <Tab.Screen name="Main" component={MainScreen} />
      <Tab.Screen name="Monthly" component={Monthly} />
      <Tab.Screen name="Analy" component={Analy} />
    </Tab.Navigator>
  );
}

function App() {
  return (
    <NavigationContainer>
      <Stack.Navigator>
        <Stack.Screen name="Home" component={Home} />
        <Stack.Screen name="DeptPage" component={DeptPage} />
        <Stack.Screen name="InfoDetails" component={InfoDetails} />
      </Stack.Navigator>
    </NavigationContainer>
  );
}

const style = StyleSheet.create({
  modalToggle: {

    padding: 10,
    borderRadius: 10,
    alignSelf: 'flex-start',
    marginTop: -40, //위치를 center로
  },
  modalClose: {
    alignSelf: 'center',
    alignItems: 'flex-start',
    marginTop: 150,
    marginBottom: 50,
  },
  modalContent: {
    flex: 1, //이후 유용한 키보드를 추가하려고 ex)dismissing keyboard
  },

  TextInput: {
    borderColor: 'skyblue',
    height: 40,
    margin: 12,
    borderWidth: 1
  },
  Font: {
    fontSize: 24
  }
});
export default App;
