import React, {useState} from 'react';
import {StyleSheet, Text,View, TextInput, Button} from 'react-native'; //추가하기 때문에TextInput, Button을 import 함


export default function AddTodo({submitHandler}) {
    const [text, setText] = useState(''); //empty string

    const changeHandler = (val) => {
        setText(val);
    }

    return(
        <View>
            <TextInput
                style = {styles.input}
                placeholder = '돈 갚아라...' //처음에 나오는 text
                onChangeText={changeHandler} //value 받은 것 저장
            />
            <Button onPress= {() =>submitHandler(text)} title = '입력' color = 'coral' />
        </View>
    )
}

const styles = StyleSheet.create({
    input: {
        marginBottom: 10,
        paddingHorizontal: 8,
        paddingVertical:6,
        borderBottomColor: '#ddd', //light grey
        borderBottomWidth: 1

    }
})