import React from 'react';
import { StyleSheet, Text, View } from 'react-native';
import Ionicons from 'react-native-vector-icons/Ionicons';

function TodoItem({ item, onDeleteHandle }) {
    return (
        <View style={styles.item}>
            <Ionicons name='trash-outline' size={15} color='#333' onPress={onDeleteHandle} />
            <Text style={styles.itemText}>{item.date}</Text>
            <Text style={styles.itemText}>{item.message}</Text>
            {item.money ? <Text style={styles.itemText}>{(item.repayment).toLocaleString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")} / {(item.money).toLocaleString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</Text> : null}
        </View>
    )
}

const styles = StyleSheet.create({
    item: {
        padding: 16,
        marginTop: 16,
        borderColor: '#bbb',
        borderWidth: 1,
        borderStyle: 'd',
        borderStyle: 'dashed',
        borderRadius: 10,
        flexDirection: 'row'
    },
    itemText: {
        fontFamily: 'GowunDodum-Regular',
        marginLeft: 10,
        fontSize: 15
    }
})

export default TodoItem;