import React from 'react';
import { View, Text, TextInput, StyleSheet, Button } from 'react-native';
import WeeklyCalendar from './components/WeeklyCalendar';
import InsertCat from './InsertCat';

function MainScreen({ navigation }) {
    const [number, onChangeNumber] = React.useState(null);
    return (
        <>
            <View>
                <WeeklyCalendar />
                <Text style={style.Font}>여기는 메인 페이지 입니다.</Text>
                <Text style={style.Font}>아래는 input 테스트를 위한 것입니다.</Text>
                <TextInput
                    style={style.TextInput}
                    onChangeText={onChangeNumber}
                    keyboardType="numeric"
                />
                <Text>입력한 숫자 보기: {number} </Text>
            </View>
            <Button
                title="월별 페이지로 이동"
                onPress={() => navigation.navigate('Monthly')}
            />
            <InsertCat />
        </>
    )
}

const style = StyleSheet.create({
    TextInput: {
        borderColor: 'skyblue',
        height: 40,
        margin: 12,
        borderWidth: 1
    },
    Font: {
        fontSize: 24
    }
});

export default MainScreen;