import React from 'react';
import { StyleSheet, Text, TouchableOpacity, View } from 'react-native';
import Ionicons from 'react-native-vector-icons/Ionicons';

//item은 앞의 text를 받음
export default function TodoItem({ item, pressHandler }) {

    return (
        <TouchableOpacity onPress={() => pressHandler(item.key)}>
            <View style={styles.item}>
                <Ionicons name='trash-outline' size={15} color='#333' />
                <Text style={styles.itemText}>{item.text}</Text>
            </View>
        </TouchableOpacity>
    )

}

const styles = StyleSheet.create({
    item: {
        padding: 16,
        marginTop: 16,
        borderColor: '#bbb', //light grey
        borderWidth: 1,
        borderStyle: 'd',
        borderStyle: 'dashed', //little line
        borderRadius: 10,
        flexDirection: 'row' //같은 행에 있도록
    },
    itemText: {
        marginLeft: 10,
    }
})