import React, { useState } from 'react';
import { StyleSheet, Text, View, FlatList, Alert, TouchableWithoutFeedback, Keyboard } from 'react-native';
import Header from './components/header';
import TodoItem from './components/todoItem';
import AddTodo from './components/addTodo';
import Sandbox from './components/sandbox';


export default function DeptPage() {
    const [todos, setTodos] = useState([
        { text: 'buy coffee', key: '1' },
        { text: 'create an app', key: '2' },
        { text: 'play on the swithch', key: '3' }
    ]);

    const pressHandler = (key) => {
        setTodos((prevTodos) => {
            return prevTodos.filter(todo => todo.key != key);
        });
    }

    //이 함수로 내용 추가를 함 Addtodo함수에서 이용
    const submitHandler = (text) => {
        //alert를 사용하기위해 조건문 지정
        if (text.length > 3) {
            setTodos((prevTodos) => {
                return [
                    { text: text, key: Math.random().toString() },
                    ...prevTodos  //앞의 todos에 추가하여 내용을 더 추가함
                ];
            });
        } else { //3글자 보다 작으면 alert
            Alert.alert('OOPs!', '3글짜 이상!', [
                { text: 'Understood', onPress: () => console.log('alert closed') }//understood 버튼 누르면 alert꺼짐
            ]);
        }
    }

    return (
        // <Sandbox />
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
            console.log('dismissed keyboard');
        }}>

            <View Style={styles.container}>
                <Header />
                <View style={styles.content}>
                    <AddTodo submitHandler={submitHandler} />
                    <View style={styles.list}>
                        <FlatList
                            data={todos}
                            renderItem={({ item }) => (
                                <TodoItem item={item} pressHandler={pressHandler} />
                            )}
                        />
                    </View>
                </View>
            </View>
        </TouchableWithoutFeedback>
    );
}


//content는 내용이 추가되면 계속 커진다
const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: '#fff',
    },
    content: {
        padding: 40,
    },
    list: {
        marginTop: 20, //top에서부터 거리
    }
});