import React, { useState } from 'react';
import { StyleSheet, View, Text, TextInput, Button } from 'react-native';
import { NavigationContainer } from '@react-navigation/native';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import { createStackNavigator } from '@react-navigation/stack';
import Ionicons from 'react-native-vector-icons/Ionicons';
import Monthly from './Monthly';
import Analy from './Analy';
import PostMoney from './PostMoney';
import MainScreen from './MainScreen';
import DetailInfo from './DetailInfo';

const Tab = createBottomTabNavigator();
const Stack = createStackNavigator();

function Home() {
  return (
    <Tab.Navigator screenOptions={({ route }) => ({
      tabBarIcon: ({ focused, color, size }) => {
        let iconName;

        if (route.name === 'Main') {
          iconName = focused
            ? 'home'
            : 'home-outline';
        } else if (route.name === 'Monthly') {
          iconName = focused ? 'calendar' : 'calendar-outline';
        } else if (route.name === 'Analy') {
          iconName = focused ? 'bar-chart' : 'bar-chart-outline';
        }
        // else if (route.name === 'Calendar') {
        //   iconName = focused ? 'calendar-sharp' : 'calendar-sharp';
        // }

        // You can return any component that you like here!
        return <Ionicons name={iconName} size={size} color={color} />;
      },
    })}
      tabBarOptions={{
        activeTintColor: 'skyblue',
        inactiveTintColor: 'gray',
      }}>
      <Tab.Screen name="Main" component={MainScreen} />
      <Tab.Screen name="Monthly" component={Monthly} />
      {/*<Tab.Screen name="Calendar" component={Calendar} />*/}
      <Tab.Screen name="Analy" component={Analy} />
      <Tab.Screen name="PostMoney" component={PostMoney} />
    </Tab.Navigator>
  )
}

function App() {
  return (
    <NavigationContainer>
      <Stack.Navigator>
        <Stack.Screen options={{ headerShown: false }} name="Home" component={Home} />
        <Stack.Screen name="DetailInfo" component={DetailInfo} />
      </Stack.Navigator>
    </NavigationContainer>
  );
}

const style = StyleSheet.create({
  TextInput: {
    borderColor: 'skyblue',
    height: 40,
    margin: 12,
    borderWidth: 1
  },
  Font: {
    fontSize: 24
  },
  Contents: {
    justifyContent: "center",
    alignItems: "center",
    margin: 10
  }
});
export default App;
