import React, { useState, useEffect } from 'react';
import { SafeAreaView, StyleSheet, View, Text, FlatList, TouchableOpacity } from 'react-native';
import { Button } from 'react-native-elements';
import Ionicons from 'react-native-vector-icons/Ionicons';

const DateItem = ({ dateitem, onPress, backgroundColor, textColor, flatListHeight }) => {
  return (
    <TouchableOpacity onPress={onPress}
     style={[style.dateContainer, backgroundColor, {height: flatListHeight}]}>
      <Text style={textColor}>{dateitem}</Text>
      <Text style={{color:'blue'}}>100,000</Text>
    </TouchableOpacity>
  );
};

function Calendar() {
  const date = new Date();
  const [year, setYear] = useState(date.getFullYear());
  const [month, setMonth] = useState(date.getMonth());
  const todayM = date.getMonth();
  const todayY = date.getFullYear();
  const [flatListHeight, setFlatListHeight] = useState(400)

  const prevLast = new Date(year, month, 0); //이전 달의 마지막 날
  const thisFirst = new Date(year, month, 1); //이번 달의 첫째 날
  const thisLast = new Date(year, month + 1, 0); //이번 달의 마지막 날

  const thisFirstDay = thisFirst.getDay(); //이번 달 첫번 째 요일
  const prevLastDate = prevLast.getDate(); //이전 달 마지막 날짜
  const thisLastDate = thisLast.getDate(); //이번 달 마지막 날짜
  const thisLastDay = thisLast.getDay(); //이번 달 마지막 요일

  // 이번 달 달력에 쓰일 날짜들. 이전달 다음달 전부 포함
  const tempDates = [];
  if (thisFirstDay != 0) { // 첫째 날이 일요일이 아니라면
    for (let i = 0; i < thisFirstDay; i++) {
      tempDates.unshift(prevLastDate - i);
    } // 이전 달의 마지막 날짜부터 1씩 감소시켜서 배열에 값 추가.
  }
  for (let i = 1; i <= thisLastDate; i++) { //이번 달 날짜 
    tempDates.push(i);
  }
  for (let i = 1; i <= 6 - thisLastDay; i++) {
    tempDates.push(i);
  }
  const dates = tempDates.map((element, index) => ({ key: `${index}`, idates: element }));

  const thisfirstID = tempDates.indexOf(1); // 이번 달 1일
  const thislastID = tempDates.lastIndexOf(thisLastDate); // 이번 달 마지막 날짜 인덱스

  let istoday = false;

  const [selectedKey, setSelectedKey] = useState(null);

  const renderDate = ({ item }) => {
    const backgroundColor = item.key === selectedKey ? '#87ceeb' : '#FFFAFA';
    let color = '#000000';
    if (item.idates === date.getDate() && month === todayM && year === todayY) {
      istoday = true;
    }
    if (istoday) {
      color = '#6495ed'
      istoday = false;
    }
    if (!(item.key >= thisfirstID && item.key < thislastID + 1)) {
      color = '#a9a9a9'
    }
    return (
      <DateItem dateitem={item.idates} onPress={() => setSelectedKey(item.key)} backgroundColor={{ backgroundColor }} textColor={{ color }} flatListHeight={flatListHeight / 5} />
    )
  }

  const prevBtn = () => {
    setSelectedKey(null)
    if (month < 1) {
      setYear(year - 1)
      setMonth(11)
    } else {
      setMonth(month - 1)
    }
  };

  const nextBtn = () => {
    setSelectedKey(null)
    if (month > 10) {
      setYear(year + 1)
      setMonth(0)
    } else {
      setMonth(month + 1)
    }
  }

  useEffect(() => {
    setMonth(todayM)
    setYear(todayY)
    setSelectedKey(null)
  }, [])

  const onLayout=(event)=> {
    const {x, y, height, width} = event.nativeEvent.layout;
    setFlatListHeight(height)
  }
  return (
    <>
      <SafeAreaView style={style.EntContainer}>
        <View style={style.Container}>
          <Text style={style.Head}>{year} 년 {month + 1} 월</Text>
          <View style={style.Buttons}>
            <Button icon={
              <Ionicons name='chevron-back-sharp' onPress={prevBtn} size={15} color='black' />
            } type='clear' />
            <Button title='Today' onPress={() => { setMonth(todayM); setYear(todayY) }} type='clear' />
            <Button icon={
              <Ionicons name='chevron-forward-sharp' onPress={nextBtn} size={15} color='black' />
            } type='clear' />
          </View>
        </View>
        <View style={style.Days}>
          <Text style={style.DayText}>월</Text>
          <Text style={style.DayText}>화</Text>
          <Text style={style.DayText}>수</Text>
          <Text style={style.DayText}>목</Text>
          <Text style={style.DayText}>금</Text>
          <Text style={style.DayText}>토</Text>
          <Text style={style.DayText}>일</Text>
        </View>
        <FlatList style={style.ListContainer}
        onLayout={onLayout}
          contentContainerStyle={style.wrapper}
          data={dates}
          numColumns={7}
          renderItem={renderDate}
          extraData={selectedKey} />
      </SafeAreaView>
    </>
  )
}

const style = StyleSheet.create({
  wrapper: {
    alignItems: 'stretch',
    alignContent: 'stretch'
  },
  EntContainer: { //전체 (SafeAreaView)
    flex: 1,
    padding: 20
  },
  Head: { //00년00월
    fontSize: 24,
  },
  Container: { //년월, 버튼 뷰에 적용
    justifyContent: "center",
    alignItems: "center",
  },
  dateContainer: { //각 date에 적용 (Text 태그), DateItem 컴포넌트에 적용
    flex: 1,
    borderWidth: 0.8,
    borderColor: '#DCDCDC'
  },
  Buttons: {
    flexDirection: 'row',
    margin: 10
  },
  Days: {
    flexDirection: 'row'
  },
  DayText: {
    flex: 1,
    textAlign: 'center'
  },
});

export default Calendar;