import React, { useEffect, useState } from 'react';
import { View, Text, StyleSheet, FlatList, Modal, Pressable } from 'react-native';
import editApi from './db/editOption.api';
import AntDesign from 'react-native-vector-icons/AntDesign';
import InputBox from './components/InputBox';
import StyledButton from './components/StyledButton';
import Accordion from './components/Accordion';

const INIT_OPTION = { id: 0, value: '' }
const TEST_OPTION = { id: 15, value: 'testtest' }
const TEST_SUB = [{
  id: 1, value: 'test1',
},
{
  id: 2, value: 'test2'
}]

const EditOption = ({ route }) => {
  console.log('catEdit: type_id ', route.params)
  const type_id = route.params
  const [options, setOptions] = useState([])
  const [option, setOption] = useState(INIT_OPTION)

  const [modalOpen, setModalOpen] = useState(false)
  const modalClose = () => { setModalOpen(false); setOption(INIT_OPTION) }

  const [error, setError] = useState("");
  const [loading, setLoading] = useState(false);

  useEffect(() => {
    if (type_id > 0) {
      loadCat()
    } else {
      loadAsset()
    }
  }, [])

  const loadCat = async () => {
    try {
      const catArray = await editApi.selectCategories(type_id)
      setOptions(catArray)
    } catch (error) {

    }
  }

  const loadAsset = async () => {
    try {
      const assetArray = await editApi.selectAssetsType()
      setOptions(assetArray)
    } catch (error) {

    }
  }

  const handleUpdate = () => {
    if (type_id > 0) {
      updateCat()
    } else {
      updateAsset()
    }
  }

  const updateAsset = async () => {
    try {
      const res = await editApi.updateOption('assets_type', { id: option.id, name: 'assets', value: option.value })
      console.log(res)
      loadAsset()
      modalClose()
    } catch (error) {

    }
  }

  const updateCat = async () => {
    try {
      const res = await editApi.updateOption('categories', { id: option.id, name: 'category', value: option.value })
      console.log(res)
      loadCat()
      modalClose()
    } catch (error) {

    }
  }

  const handleDelete = (item) => {
    if (type_id > 0) {
      deleteCat(item)
    } else {
      deleteAsset(item)
    }
  }

  const deleteAsset = async (item) => {
    try {
      const res = await editApi.deleteOption('assets_type', { id: item.id, name: 'assets' })
      console.log(res)
      loadAsset()
      modalClose()
    } catch (error) {

    }
  }

  const deleteCat = async (item) => {
    try {
      const res = await editApi.deleteOption('categories', { id: item.id, name: 'category' })
      console.log(res)
      loadCat()
      modalClose()
    } catch (error) {

    }
  }

  const handleAdd = () => {
    if (type_id > 0) {
      addCat()
    } else {
      addAsset()
    }
  }

  const addAsset = async () => {
    try {
      const res = await editApi.addOption('assets_type', { name: 'assets', value: option.value })
      console.log(res)
      loadAsset()
      modalClose()
    } catch (error) {

    }
  }

  const addCat = async () => {
    try {
      const res = await editApi.addOption('categories', { name: 'category', value: option.value, foreign_name: 'type', foreign_id: type_id })
      console.log(res)
      loadCat()
      modalClose()
    } catch (error) {

    }
  }

  const renderOptionItem = ({ item }) => (
    <View style={[style.flexRow, style.catBox]}>
      <View style={style.flexRow}>
        {item.deletable && <AntDesign name='minuscircle' style={style.cancelIcon} onPress={() => { handleDelete(item) }} />}
        <Text style={style.optionText} >
          {item.value}
        </Text>
      </View>
      <View style={[style.flexRow, style.flexCenter]}>
        {item.deletable && <AntDesign name='edit' style={style.icon} onPress={() => { setOption(item); setModalOpen(true) }} />}
        <AntDesign name='right' style={style.rightIcon} onPress={() => console.log('서브 카테고리 더보기')} />
      </View>
    </View>
  );

  return (
    <>
      {console.log(option)}
      <View>
        <FlatList
          data={options}
          renderItem={renderOptionItem}
          keyExtractor={item => item.id.toString()}
        />
        <Accordion subItems={TEST_SUB}>
          <View style={[style.flexRow, style.catBox]}>
            <View style={style.flexRow}>
              <AntDesign name='minuscircle' style={style.cancelIcon} onPress={() => { handleDelete({ TEST_OPTION }) }} />
              <Text style={style.optionText} >
                {TEST_OPTION.value}
              </Text>
            </View>
            <View style={[style.flexRow, style.flexCenter]}>
              <AntDesign name='edit' style={style.icon} onPress={() => { setOption(TEST_OPTION); setModalOpen(true) }} />
              <AntDesign name='right' style={style.rightIcon} onPress={() => console.log('서브 카테고리 더보기')} />
            </View>
          </View>
        </Accordion>
        <Pressable style={style.addButton} onPress={() => setModalOpen(true)}>
          <AntDesign name='plus' style={style.icon} />
          <Text style={style.optionText} >추가하기</Text>
        </Pressable>
      </View>

      <Modal
        transparent
        swipeDirection="down"
        animationType_id="fade"
        visible={modalOpen}
        onRequestClose={modalClose}
      >
        <View style={style.modalContainer}>
          <View style={style.modalHeader}>
            <View style={{ flexDirection: "row" }}>
              <AntDesign name='caretleft' style={style.icon} onPress={() => modalClose()} />
              <Text style={style.Font}>{option.id === 0 ? '추가' : '수정'}</Text>
            </View>
          </View>
          <View style={style.modalBody}>
            <InputBox
              placeholder="이름을 입력하세요."
              onChangeText={
                (name) => setOption({ ...option, value: name })
              }
              value={option.value}
              maxLength={30}
            />
            <View style={style.buttonRow}>
              <StyledButton
                name="저장하기"
                onPress={option.id === 0 ? handleAdd : handleUpdate}
                style={style.submitButton}
              />
            </View>
          </View>
        </View>
      </Modal>
    </>

  )
}

const style = StyleSheet.create({
  flexRow: {
    flexDirection: 'row',
  },
  flexCenter: {
    justifyContent: 'center',
    alignItems: 'center',
  },
  catBox: {
    justifyContent: 'space-between',
    paddingVertical: 10,
    backgroundColor: 'lightgray',
  },
  Font: {
    fontSize: 24
  },
  icon: {
    marginHorizontal: 5,
    fontSize: 30,
    color: 'black',
  },
  cancelIcon: {
    marginHorizontal: 5,
    fontSize: 30,
    color: 'red',
  },
  rightIcon: {
    marginHorizontal: 5,
    fontSize: 20,
    color: 'black',
  },
  optionText: {
    fontSize: 20,
    marginHorizontal: 10,
  },
  addButton: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    paddingVertical: 10,
    backgroundColor: 'gray',
    margin: 15
  },
  modalContainer: {
    flex: 1,
    backgroundColor: 'white',
  },
  modalHeader: {
    padding: 10,
  },
  modalBody: {

  },
  buttonRow: {
    flexDirection: 'row',
    alignItems: "center",
    marginHorizontal: 10,
    marginVertical: 3,
  },
  submitButton: {
    flex: 1,
    height: 50,
  },
});

export default EditOption;