import React from 'react';
import { StyleSheet } from 'react-native';
import { NavigationContainer } from '@react-navigation/native';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import { createStackNavigator } from '@react-navigation/stack';
import Ionicons from 'react-native-vector-icons/Ionicons';
import Monthly from './Monthly';
import Analy from './Analy';
import PostMoney from './PostMoney';
import MainScreen from './MainScreen';
import DetailInfo from './DetailInfo';
import DeptPage from './DeptPage';
import InfoDetails from './screens/InfoDetails';
import MemoPage from './MemoPage';
import MemoDetails from './screens/MemoDetails';
import EditOption from './EditOption';

const Tab = createBottomTabNavigator();
const Stack = createStackNavigator();

function Home() {
  return (
    <Tab.Navigator screenOptions={({ route }) => ({
      tabBarIcon: ({ focused, color, size }) => {
        let iconName;

        if (route.name === 'Main') {
          iconName = focused
            ? 'home'
            : 'home-outline';
        } else if (route.name === 'Monthly') {
          iconName = focused ? 'calendar' : 'calendar-outline';
        } else if (route.name === 'Analy') {
          iconName = focused ? 'bar-chart' : 'bar-chart-outline';
        }
        return <Ionicons name={iconName} size={size} color={color} />;
      },
    })}
      tabBarOptions={{
        activeTintColor: 'skyblue',
        inactiveTintColor: 'gray',
      }}>
      <Tab.Screen name="Main" component={MainScreen} />
      <Tab.Screen name="Monthly" component={Monthly} />
      <Tab.Screen name="Analy" component={Analy} />
      <Tab.Screen name="PostMoney" component={PostMoney} />
    </Tab.Navigator>
  )
}

function App() {
  return (
    <NavigationContainer>
      <Stack.Navigator screenOptions={{
        headerStyle: {
          backgroundColor: '#eee'
        },
        headerTitleStyle: {
          fontWeight: 'bold',
        },
        headerTitleAlign: 'center'
      }} >
        <Stack.Screen
          name="Home"
          component={Home}
          options={{ headerShown: false }} />
        <Stack.Screen
          name="DeptPage"
          component={DeptPage}
          options={{ title: "부채", headerStyle: { backgroundColor: 'coral' } }} />
        <Stack.Screen
          name="InfoDetails"
          component={InfoDetails}
          options={{ title: "상세정보" }} />
        <Stack.Screen
          name="MemoPage"
          component={MemoPage}
          options={{ title: "메모", headerStyle: { backgroundColor: 'coral' } }} />
        <Stack.Screen
          name="MemoDetails"
          component={MemoDetails}
          options={{ title: "상세내용" }} />
        <Stack.Screen name="DetailInfo" component={DetailInfo} />
        <Stack.Screen
          name="EditOption"
          component={EditOption}
          options={{ title: "편집" }}
        />
      </Stack.Navigator>
    </NavigationContainer>
  );
}

const style = StyleSheet.create({

  TextInput: {
    borderColor: 'skyblue',
    height: 40,
    margin: 12,
    borderWidth: 1
  },
  Font: {
    fontSize: 24
  },
  Contents: {
    justifyContent: "center",
    alignItems: "center",
    margin: 10
  }
});
export default App;
