import React from 'react';
import { StyleSheet, Picker, View, Text } from 'react-native';
import { ListItem, Icon } from 'react-native-elements'

const SelectForm = (props) => {
    return (
        <View style={styles.container}>
            <View style={styles.inputTitleArea}>
                <Text style={styles.inputTitle}>{props.inputTitle}</Text>
            </View>
            <Picker
                selectedValue={props.selectedValue}
                style={styles.selectStyle}
                onValueChange={props.onValueChange}
            >
                {props.categories.map((index, item)=>{
                    return(
                        <Picker.Item label={item.category_name} value={item.category_name} />
                    )
                })}
            </Picker>
        </View>
    );
};

const styles = StyleSheet.create({
    container: {
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
        borderWidth: 1.5,
        borderStyle: "solid",
        borderColor: "#1467ff",
        borderRadius: 5,
        backgroundColor: "#f5f5f5",
    },
    inputTitleArea: {
        flex: 1,
    },
    inputTitle: {
        alignSelf: "center",
        color: "#1467ff",
        fontSize: 20,
    },
    selectStyle: {
        flex: 3,
        fontSize: 20,
    },
})

export default SelectForm