import { DatePickerAndroid } from 'react-native';

const DatePicker = (props) => {
    return (
        <View>
            <Text style={{ fontSize: 18, marginLeft: 10, marginTop: 10 }}>Arrival/Departure:</Text>
            <DatePicker
                style={{ padding: 10 }}
                date={this.state.date_in}
                mode="date"
                format="YYYY-MM-DD"
                minDate="2016-05-01"
                maxDate="2016-06-01"
                showIcon={false}
                customStyles={{
                    dateInput: {
                        alignItems: 'flex-start',
                        padding: 5
                    },
                }}
                onDateChange={(date_in) => { this.setState({ date_in: date_in }); }} />
        </View>
    );
};

const styles = StyleSheet.create({
})

export default DatePicker