import React, { useState } from 'react';
import { View, Text, StyleSheet, Button } from 'react-native';
import { DEBUG, enablePromise, openDatabase } from 'react-native-sqlite-storage';
import InputBox from './components/InputBox';
import ButtonsForm from './components/ButtonsForm';
import SelectForm from './components/SelectForm';
import StyledButton from './components/StyledButton';

DEBUG(true);
enablePromise(true);

const db = openDatabase({
  name: 'MyMoney',
  location: 'default',
  createFromLocation: '~MyMoney.db', // android/src/main/assets/TestDB.db 파일을 위치 시킴
});

const INIT_ASSET_TYPE = [
    {
        asset_id: '1',
        asset_name: '농협',
    },
    {
        asset_id: '2',
        asset_name: '신한',
    },
]

const INIT_CATEGORIES = [
    {
        category_id: '1',
        category_name: '식비',
    },
    {
        category_id: '2',
        category_name: '문화',
    },
    {
        category_id: '3',
        category_name: '교통비',
    },
    {
        category_id: '4',
        category_name: '기타',
    },
]

const PostMoney = () => {
    const [selectedIndex, setSelectedIndex] = useState(0)
    const [date, setDate] = useState('2021-07-09')
    const [contents, setContents] = useState('')
    const [price, setPrice] = useState(0)
    const [asset_type, setAsset_type] = useState(INIT_ASSET_TYPE)
    const [selected_asset_type, setSelected_asset_type] = useState(INIT_ASSET_TYPE[0])
    const [categories, setCategories] = useState(INIT_CATEGORIES)
    const [selected_cat, setSelected_cat] = useState(INIT_CATEGORIES[0])

    console.log('입력 데이터 : ', selectedIndex, contents, price, selected_asset_type, selected_cat)

    const insertData = async () => {
        try {
            if (selectedIndex === 0) {type = '수입'}
            else if (selectedIndex === 1) {type = '지출'}
            else {type = '이동'}

          (await db).transaction((tx) => {
            console.log("데이터 삽입하기");
            tx.executeSql('INSERT INTO Money (type, date, contents, price, asset_type, category) VALUES (?,?);',
              [expense, income],
              () => { console.log("삽입 성공"); },
              (error) => console.log(error))
          })
        } catch (error) {
          console.log('error in insert data', error)
        }
      }

    return (
        <View>
            <View>
                <ButtonsForm
                    onPress={(index) => setSelectedIndex(index)}
                    selectedIndex={selectedIndex}
                    group={["수입", "지출", "이동"]} />
                <InputBox
                    inputTitle="내용"
                    placeholder="내용을 입력하세요"
                    onChangeText={
                        (contents) => setContents(contents)
                    }
                    maxLength={30}
                />
                <InputBox
                    inputTitle="금액"
                    placeholder="금액을 입력하세요"
                    onChangeText={
                        (price) => setPrice(price)
                    }
                    keyboardType="numeric"
                    maxLength={30}
                />
                <SelectForm
                    inputTitle="자산"
                    categories={asset_type}
                    selectedValue={selected_asset_type}
                    onValueChange={(itemValue, itemIndex) => setSelected_asset_type(itemValue)}
                />
                <SelectForm
                    inputTitle="구분"
                    categories={categories}
                    selectedValue={selected_cat}
                    onValueChange={(itemValue, itemIndex) => setSelected_cat(itemValue)}
                />
            </View>
            <View style={style.buttonRow}>
                <StyledButton
                    name="저장하기"
                    onPress={() => console.log('저장버튼')}
                    style={style.submitButton}
                />
                <StyledButton
                    name="취소"
                    onPress={() => console.log('취소버튼')}
                    style={style.cancelButton}
                />
            </View>
        </View>
    )
}

const style = StyleSheet.create({
    Font: {
        fontSize: 24
    },
    buttonRow: {
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
    },
    submitButton: {
        flex: 3,
        height: 50,
    },
    cancelButton: {
        flex: 1,
        height: 50,
    }
});

export default PostMoney;