import React, { useEffect, useRef, useState } from 'react';
import { Animated, Text, View, StyleSheet, TouchableOpacity, FlatList } from 'react-native';

const renderOptionItem = ({ item }) => (
    <View style={[style.flexRow, style.catBox]}>
        <View style={style.flexRow}>
            {/* { item.deletable && <AntDesign name='minuscircle' style={style.cancelIcon} onPress={() => { handleDelete(item) }} />} */}
            <Text style={style.optionText} >
                {item.value}
            </Text>
        </View>
        {/* <View style={[style.flexRow, style.flexCenter]}>
        { item.deletable && <AntDesign name='edit' style={style.icon} onPress={() => { setOption(item); setModalOpen(true) }} /> }
        <AntDesign name='right' style={style.rightIcon} onPress={() => console.log('서브 카테고리 더보기')}/>
      </View> */}
    </View>
);

const Accordion = ({
    item,
    subItems,
    children
}) => {
    let layoutHeight = 0;
    const [bodyMounted, setBodyMounted] = useState(false);
    const [bodyHeight, setBodyHeight] = useState(0);
    let dropDownAnimValueList = useRef(new Animated.Value(0)).current;

    const handleBodyLayout = (e) => {
        if (bodyMounted) return;

        console.log(e.nativeEvent.layout)

        const { height } = e.nativeEvent.layout;
        layoutHeight = height;
        setBodyMounted(true);
        setBodyHeight(height);
    }

    const [open, setOpen] = useState(false);

    // const openList = () => {
    //     Animated.timing(dropDownAnimValueList, {
    //         toValue: 0,
    //         duration: 500,
    //         useNativeDriver: true,
    //     })
    // }

    // const closeList = () => {
    //     Animated.timing(dropDownAnimValueList, {
    //         toValue: -bodyHeight,
    //         duration: 500,
    //         useNativeDriver: true,
    //     })
    // }

    useEffect(() => {
        if (bodyMounted) dropDownAnimValueList.setValue(open ? -layoutHeight : 0);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [bodyMounted]);

    useEffect(() => {
        // if (shouldAnimate) {
        //     if (!opened) {
        //       Animated.timing(dropDownAnimValueList, {
        //         toValue: 0,
        //         duration: animDuration || 300,
        //         useNativeDriver: true,
        //       }).start();

        //       return;
        //     }

        //     Animated.timing(dropDownAnimValueList, {
        //       toValue: -bodyHeight,
        //       duration: animDuration || 300,
        //       useNativeDriver: true,
        //     }).start();
        //   } else {
        const targetValue = open ? -bodyHeight : 0;

        dropDownAnimValueList.setValue(targetValue);
        //   }
        // if (open) dropDownAnimValueList.setValue(open ? -layoutHeight : 0);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [open]);

    console.log(open)

    return (
        <Animated.View style={[
            {
                overflow: 'hidden',
                transform: [{
                    translateY: 0,
                }],
            },
        ]}>
            <View style={[style.boxContainer]}>
                <TouchableOpacity onPress={() => { setOpen(!open) }}>
                    {children}
                </TouchableOpacity>
            </View>

            <Animated.View style={{
                height: !bodyMounted ? undefined : bodyHeight,
                transform: [
                    {
                        translateY: dropDownAnimValueList,
                    },
                ],
            }}
                onLayout={handleBodyLayout}>
                <FlatList
                    data={subItems}
                    renderItem={renderOptionItem}
                    keyExtractor={item => item.id.toString()}
                />
            </Animated.View>
        </Animated.View>
    )
}

const Accordion

const style = StyleSheet.create({
    boxContainer: {
        width: '100%',
        position: 'relative',
    },
    flexRow: {
        flexDirection: 'row',
    },
    flexCenter: {
        justifyContent: 'center',
        alignItems: 'center',
    },
    catBox: {
        justifyContent: 'space-between',
        paddingVertical: 10,
        backgroundColor: 'lightgray',
    },
    zIndex: {
        position: 'absolute',
        zIndex: 15,
        elevation: 1000,
    },
    icon: {
        marginHorizontal: 5,
        fontSize: 30,
        color: 'black',
    },
    cancelIcon: {
        marginHorizontal: 5,
        fontSize: 30,
        color: 'red',
    },
    rightIcon: {
        marginHorizontal: 5,
        fontSize: 20,
        color: 'black',
    },
    optionText: {
        fontSize: 20,
        marginHorizontal: 10,
    },
    items: {
        overflow: "hidden"
    }
})

export default Accordion