import React from 'react';
import { FlatList, View, Text, StyleSheet, Dimensions } from 'react-native';
import { Button } from 'react-native-elements';
import Ionicons from 'react-native-vector-icons/Ionicons';
import { PieChart } from "react-native-chart-kit";

const screenWidth = Dimensions.get("window").width;
const screenHeight = Dimensions.get("window").height;

const ChartItem = ({ item }) => {
  return (
    <>
      <View style={{
        flexDirection: "row", padding: "5%", borderColor: '#d3d3d3', //light grey
        borderWidth: 1, borderTopWidth: 0,
      }}>
        <Text style={[style.itemText, style.Font]}>{item.name}</Text>
        <Text style={[style.itemTextNum, style.Font]}>{(item.total).toLocaleString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}</Text>
        <Text style={[style.itemTextNum, style.Font]}>{item.percentage}%</Text>
      </View>
    </>
  );
};

const ChartM = ({
  resDataM,
  year,
  setYear,
  month,
  setMonth
}) => {
  const chartConfig = {
    backgroundGradientFrom: "#abbcd6",
    backgroundGradientFromOpacity: 0.5,
    backgroundGradientTo: "#E6DDC5",
    backgroundGradientToOpacity: 0.2,
    color: (opacity = 1) => `rgba(0, 93, 232, ${opacity})`,
    strokeWidth: 2, // optional, default 3
    barPercentage: 0.5, // 그래프 width
    useShadowColorFromDataset: false,// optional, default is false
    fillShadowGradientOpacity: 1,

  };

  const renderChart = ({ item }) => {
    return (
      <ChartItem item={item} />
    )
  }
  const prevBtn = () => {
    if (month < 1) {
      setYear(year - 1)
      setMonth(11)
    } else {
      setMonth(month - 1)
    }
  };
  const nextBtn = () => {
    if (month > 10) {
      setYear(year + 1)
      setMonth(0)
    } else {
      setMonth(month + 1)
    }
  }
  return (
    <>
      <View style={{ flexDirection: 'row', justifyContent: "center", alignItems: "center" }}>
        <Button icon={
          <Ionicons name='chevron-back-sharp' onPress={prevBtn} size={20} color='black' />
        } type='clear' />
        <Text style={{ fontFamily: 'GowunDodum-Regular', fontSize: 20 }}>{year}.{month + 1}</Text>
        <Button icon={
          <Ionicons name='chevron-forward-sharp' onPress={nextBtn} size={20} color='black' />
        } type='clear' />
      </View>
      <View>
        {
          resDataM.length !== 0 ?
            < PieChart
              data={resDataM}
              width={screenWidth}
              height={screenHeight / 3}
              chartConfig={chartConfig}
              accessor={"total"}
              backgroundColor={"#ffffff"}
            /> 
            : <Text style={style.infoText}> 지출 내역이 없습니다.</Text>
        }
        <FlatList
          style={{ backgroundColor: "#FFFFFF", height: screenHeight*0.42 }}
          data={resDataM}
          renderItem={renderChart}
          keyExtractor={item => item.color}
        />
      </View>
    </>
  )
}
const style = StyleSheet.create({
  Font: {
    fontSize: 20,
    fontFamily: 'GowunDodum-Regular'
  },
  itemTextNum: {
    flex: 1,
    textAlign: "center",
    fontFamily: 'GowunDodum-Regular'
  },
  itemText: {
    flex: 1,
    fontFamily: 'GowunDodum-Regular'
  },
  infoText: {
    fontSize: 30,
    textAlign: "center",
    marginTop: "20%",
    fontFamily: 'GowunDodum-Regular'
  }
});

export default ChartM;