import React, { useState, useEffect } from 'react';
import { TouchableOpacity } from 'react-native';
import { StyleSheet, TouchableWithoutFeedback, View, Text, Modal, FlatList, Animated } from 'react-native';
import Notification from './Notification';
import MaterialCommunityIcons from 'react-native-vector-icons/MaterialCommunityIcons';

const SelectForm = (props) => {
    const [option, setOption] = useState([])
    const [optionId, setOptionId] = useState(0)
    const [optionValue, setOptionValue] = useState('')

    const [subOption, setSubOption] = useState([])
    const [subOptionId, setSubOptionId] = useState(0)

    const [text, setText] = useState('')

    const [subOptionShow, setSubOptionShow] = useState(false)
    const [modalOpen, setModalOpen] = useState(false)

    const [notification, setNotification] = useState('')

    const onPressSelectBox = () => { setModalOpen(true) }

    const modalClose = () => { setModalOpen(false) }

    const onPressOption = (item) => {
        if (subOption !== undefined) {
            if (subOptionShow) {
                setSubOptionId(item.id)
                props.onValueChange(optionId)
                props.onSubValueChange(subOptionId)
                setText(optionValue + ` > ${item.value}`)
                modalClose()
            } else {
                setOptionId(item.id)
                setOptionValue(item.value)
                setSubOptionByOptionId(item)
            }
        } else {
            props.onValueChange(item.id)
            setOptionId(item.id)
            setOptionValue(item.value)
            setText(item.value)
            modalClose()
        }
    }

    const setSubOptionByOptionId = (item) => {
        const newOption = props.subData.filter((subItem) => {
            if (subItem.foreign_id === item.id)
                return true;
        })
        if (newOption.length === 0) {
            setNotification(`${item.value}의 세부 카테고리가 존재하지 않습니다.`)
        } else {
            setSubOption(newOption)
            setSubOptionShow(true)
        }
    }

    const renderOptionItem = ({ item }) => (
        <TouchableOpacity onPress={() => onPressOption(item)} style={style.option}>
            <Text style={style.optionText} >
                {item.value}
            </Text>
        </TouchableOpacity>
    );

    useEffect(() => {
        setOption(props.data)
        setSubOption(props.subData)
        setSubOptionShow(false)
    }, [modalOpen])

    return (
        <View>
            <View style={style.container}>
                <View style={style.inputTitleArea}>
                    <Text style={style.inputTitle}>{props.inputTitle}</Text>
                </View>
                <View style={style.selectBox}>
                    <TouchableWithoutFeedback onPress={onPressSelectBox}>
                        <Text style={style.textStyle}>
                            {text ? text : props.placeholder}
                        </Text>
                    </TouchableWithoutFeedback>
                </View>
            </View>

            <Modal
                transparent
                swipeDirection="down"
                animationType="slide"
                visible={modalOpen}
                onRequestClose={modalClose}
            >
                <View style={style.selectModalContainer}>
                    <TouchableWithoutFeedback onPress={modalClose}>
                        <View style={{ flex: 1 }}>
                            <Notification notification={notification} setNotification={setNotification} />
                        </View>
                    </TouchableWithoutFeedback>
                    <View style={style.selectModal}>
                        <View style={style.modalHeader}>
                            {subOptionShow ?
                                <View style={{ flexDirection: 'row', alignItems: 'center', justifyContent: 'center' }} >
                                    <MaterialCommunityIcons name='arrow-left' size={35} color='white' onPress={() => { setSubOptionShow(false); }} />
                                    <Text style={style.modalHeaderText}>{optionValue}</Text>
                                </View>
                                :
                                <Text style={style.modalHeaderText}>{props.inputTitle}</Text>}
                            <View style={{ flexDirection: "row" }}>
                                <MaterialCommunityIcons name='playlist-edit' size={35} color='white' onPress={() => console.log('카테고리 편집')} />
                                <MaterialCommunityIcons name='close' size={35} color='white' onPress={modalClose} />
                            </View>
                        </View>
                        <View style={[style.modalBody, props.backdropStyle]}>
                            <FlatList
                                data={subOptionShow ? subOption : option}
                                renderItem={renderOptionItem}
                                numColumns={3}
                                keyExtractor={item => item.id.toString()}
                            />
                        </View>
                    </View>
                </View>
            </Modal>
        </View>
    );
};

const style = StyleSheet.create({
    container: {
        height: 50,
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
        borderWidth: 1.5,
        borderStyle: "solid",
        borderColor: "#1467ff",
        borderRadius: 5,
        backgroundColor: "#f5f5f5",
    },
    inputTitleArea: {
        flex: 1,
    },
    inputTitle: {
        alignSelf: "center",
        color: "#1467ff",
        fontSize: 20,
    },
    selectStyle: {
        flex: 3,
        fontSize: 20,
    },
    selectBox: {
        flex: 3,
    },
    textStyle: {
        fontSize: 20,
    },
    selectModalContainer: {
        flex: 1,
        justifyContent: 'flex-end',
    },
    selectModal: {
        flex: 1,
    },
    modalHeader: {
        flex: 1,
        backgroundColor: '#4f4f4f',
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
    },
    modalHeaderText: {
        color: 'white',
        marginLeft: 25,
        fontSize: 20,
    },
    modalBody: {
        flex: 5,
        flexDirection: 'row',
        backgroundColor: '#f0f0f0',
    },
    option: {
        flex: 1,
        height: 50,
        borderWidth: 0.8,
        borderStyle: 'solid',
        borderColor: '#575757',
        backgroundColor: '#adadad',
        justifyContent: 'center',
        alignItems: 'center',
    },
    optionText: {
        fontSize: 20,
    }
})

export default SelectForm