import React, { useState } from "react";
import Button from "react-bootstrap/Button";
import Container from "react-bootstrap/Container";
import Row from "react-bootstrap/Row";
import Col from "react-bootstrap/Col";
import Form from "react-bootstrap/Form";
import Modal from "react-bootstrap/Modal";
import { Link } from "react-router-dom";
import { create } from "./api-user";

function Signup() {
  const [values, setValues] = useState({
    name: "",
    password: "",
    email: "",
    instructor: false,
    open: false,
    error: "",
  });

  const handleChange = (name) => (event) => {
    const { value, checked } = event.target;
    if (name === "instructor") {
      setValues({ ...values, instructor: checked });
    } else {
      setValues({ ...values, [name]: value });
    }
  };

  const handleSubmit = (event) => {
    // console.log(values);
    const user = {
      name: values.name || undefined,
      email: values.email || undefined,
      password: values.password || undefined,
      instructor: values.instructor || undefined,
    };
    create(user).then((data) => {
      if (data.error) {
        console.log(data.error);
        setValues({ ...values, error: data.error });
      } else {
        setValues({ ...values, error: "", open: true });
      }
    });
  };

  return (
    <Container fluid>
      <div>
        <h1 className="mt-3 text-center mt-1 pb-3 font-italic text-danger">Korea<br/> University</h1>
      </div>
      <Row className="justify-content-center">
        <Col className="col-sm-6 col-md-7">
          <Form>
            <Form.Group>
              <Form.Label>Name</Form.Label>
              <Form.Control
                type="text"
                placeholder="Name"
                onChange={handleChange("name")}
              />
            </Form.Group>
            <Form.Group>
              <Form.Label>Password</Form.Label>
              <Form.Control
                type="password"
                placeholder="Password"
                onChange={handleChange("password")}
              />
            </Form.Group>
            <Form.Group>
              <Form.Label>Email</Form.Label>
              <Form.Control
                type="email"
                placeholder="Email"
                onChange={handleChange("email")}
              />
            </Form.Group>
            <Form.Check
              type="checkbox"
              // checked={values.instructor}
              label="Instructor"
              onChange={handleChange("instructor")}
            />
            <Button className="my-3" onClick={handleSubmit}>
              확인
            </Button>
          </Form>
          <Modal show={values.open}>
            <Modal.Header>
              <Modal.Title>New Account</Modal.Title>
            </Modal.Header>
            <Modal.Body>New Account successfully created.</Modal.Body>
            <Modal.Footer>
              <Link to="/signin">
                <Button>Sign in</Button>
              </Link>
            </Modal.Footer>
          </Modal>
        </Col>
      </Row>
    </Container>
  );
}

export default Signup;
