import React, { useState, useEffect } from "react";
import { Link, useParams } from "react-router-dom";
import { read, removeProblem, updateProblem } from "./api-quiz";
import auth from "../auth/auth-helpers";
import Button from "react-bootstrap/Button";
import EditableProblem from "./EditableProblem";
import Container from "react-bootstrap/Container";
import Row from "react-bootstrap/Row";
import Col from "react-bootstrap/Col";


function Problems() {
    let Time = 1800100

    const [timeout, settimeout] = useState(false)

    const { quizId } = useParams();
    const [quiz, setQuiz] = useState({problems:"", author: "", title: "", course: "" });

    const jwt = auth.isAuthenticated();

    useEffect(() => {
        const abortController = new AbortController();
        const signal = abortController.signal;

        read({ quizId: quizId }, { t: jwt.token }, signal).then((data) => {
            if (data.error) {
                console.log("problem error", data.error);
            } else {
                console.log(data);
                setQuiz(data);
            }
        });
        return () => {
            abortController.abort();
        };
    }, [quizId]);

    const handleUpdate = (index, problem) => {
        console.log(`Quiz에서 handleUpdate ${index}번 실행`);
        console.log(
            `Quiz에서 handleUpdate ${JSON.stringify(quiz.problems[index])}`
        );
        console.log(
            `Quiz에서 handleUpdate updated problem ${JSON.stringify(problem)}`
        );
        updateProblem({ problemId: problem._id }, { t: jwt.token }, problem).then(
            (data) => {
                if (data.error) {
                    console.log(data.error);
                } else {
                    console.log(data);
                    const list = [...quiz.problems];
                    list[index] = data;
                    console.log(list);
                    setQuiz({ ...quiz, problems: list });
                }
            }
        );
    };

    const handleRemove = (index) => {
        console.log("Quiz에서 handleRemove 실행");
        const problem = quiz.problems[index];
        console.log(problem);
        removeProblem({ problemId: problem._id }, { t: jwt.token }).then((data) => {
            if (data.error) {
                console.log(data.error);
            } else {
                console.log("deleted Problem:", data);
                const list = [...quiz.problems];
                list.splice(index, 1);
                setQuiz({ ...quiz, problems: list });
            }
        });
    };


    return (
        <>
            <Container>
                {console.log("quiz퀴즈", quiz)}
                <div className="container-fluid">
                    <div className="text-center  font-italic font-weight-bold py-2 text-muted">{quiz.course.name}</div>
                    <div className="row justify-content-md-center">

                        <div className="col-md-auto mt-4">
                            <div className="mb-3">응시자 : {quiz.author.name}
                            </div>
                            <div className="mb-4small">문제 진척도 </div>

                            {/* <span className=" float-right ">
                                {i === quizzes.length}
                                    ?<Link to="/End">
                                    <a className="btn btn-outline-danger">제출하기</a>
                                </Link>
                                    :<button type="button" className="btn btn-outline-dark">다음</button>
                                온클릭으로 리랜더링 할 수 있게 해야함.
                            </span> */}


                            <div className="h2 mt-5">
                                <span className='mr-4 font-weight-bold text-danger'>Quiz<div></div>
                                </span>
                            </div>
                            <div className="mt-2">
                                <form>
                                    보기자리
                                    {/* {quiz.problems.map((quiz, i) => {
                                                return <div>{quiz}</div>
                                            })} */}
                                    {/* {question.Choose.map((a, index) =>
                                    <div>
                                        <input type="radio" name='answer' id={index} value={a} onChange={handleChange} checked={selected === String(a)} />
                                        <label className="font-weight-bold" htmlFor={a}>{a}</label>
                                    </div>
                                )} */}
                                </form>
                                <span className="h5 font-weight-bold"> Your Answer :</span>
                                <span className="h2 font-weight-bold text-danger"> selected</span>                         </div>
                        </div>
                        <div className="col">
                        </div>
                    </div>
                </div>


            </Container >
        </>
    )
}

export default Problems;