import React, { useState } from "react";
import Card from "react-bootstrap/Card";
import Form from "react-bootstrap/Form";
import Col from "react-bootstrap/Col";
import Button from "react-bootstrap/Button";
import ButtonGroup from "react-bootstrap/ButtonGroup";
import ToggleButton from "react-bootstrap/ToggleButton";
import ToggleButtonGroup from "react-bootstrap/ToggleButtonGroup";

const EditableForm = (props) => {
  const {
    problem,
    number,
    handleCorrect,
    removeAnswer,
    addAnswer,
    handleQuestion,
    handleAnswer,
    handleSave,
    handleCancel,
  } = props;
  return (
    <Form>
      {number + 1}번.
      <Form.Group>
        <Form.Control
          value={problem.question}
          name="question"
          onChange={handleQuestion}
        />
      </Form.Group>
      <Form.Label>Answers</Form.Label>
      {/* <ToggleButtonGroup type="radio" name="radio" > */}
      {problem.answers.map((answer, index) => {
        return (
          <Form.Row key={index}>
            <Col>
              <Form.Check
                type="radio"
                value={index}
                name="correct"
                onChange={handleCorrect}
              />
            </Col>
            <Col>
              <Form.Control
                value={answer}
                name="answer"
                onChange={(event) => handleAnswer(event, index)}
              />
            </Col>
            <Col>
              {problem.answers.length !== 1 && (
                <Button onClick={() => removeAnswer(index)}>Remove</Button>
              )}
              {problem.answers.length - 1 === index && (
                <Button onClick={addAnswer}>Add</Button>
              )}
            </Col>
          </Form.Row>
        );
      })}
      {/* </ToggleButtonGroup> */}
      <Button onClick={(event) => handleSave(event, number)}>저장</Button>
      <Button onClick={handleCancel}>취소</Button>
    </Form>
  );
};

const CardForm = (props) => {
  const { problem, number, onRemove, handleEditable } = props;
  return (
    <Card>
      <Card.Body>
        {number + 1}번<Card.Title>{problem.question}</Card.Title>
        Answers
        {problem.answers.map((answer, index) => {
          return <Card.Text key={index}>{answer}</Card.Text>;
        })}
        <Card.Text>정답: {+problem.correct + 1}</Card.Text>
        <Button onClick={handleEditable}>수정</Button>
        <Button onClick={() => onRemove(number)}>삭제</Button>
      </Card.Body>
    </Card>
  );
};

function EditableProblem({ problem, number, onUpdate, onRemove }) {
  const [editable, setEditable] = useState(false);
  const [problemEdit, setProblemEdit] = useState(problem);

  const handleEditable = (event) => {
    setEditable(!editable);
  };

  const handleCorrect = (event) => {
    const { name, value } = event.target;
    console.log("name:", name, "value:", value);
    setProblemEdit({...problemEdit, correct: value})
  };

  const handleCancel = (event) => {
    // const { name, value } = event.target;
    // console.log(name, value);
    setProblemEdit(problem);
    setEditable(!editable);
  };

  const addAnswer = () => {
    setProblemEdit({ ...problemEdit, answers: [...problemEdit.answers, ""] });
  };

  const removeAnswer = (index) => {
    const list = [...problemEdit.answers];
    list.splice(index, 1);
    setProblemEdit({ ...problemEdit, answers: list });
  };

  const handleAnswer = (event, index) => {
    const { value } = event.target;
    const list = [...problemEdit.answers];
    list[index] = value;
    setProblemEdit({ ...problemEdit, answers: list });
  };

  const handleQuestion = (event) => {
    const { value } = event.target;
    console.log("question", value);
    setProblemEdit({ ...problemEdit, question: value });
  };

  const handleSave = (event, index) => {
    onUpdate(index, problemEdit);
    setEditable(!editable);
  };

  return (
    <>
      {editable ? (
        <EditableForm
          number={number}
          problem={problemEdit}
          handleCorrect={handleCorrect}
          handleSave={handleSave}
          handleCancel={handleCancel}
          removeAnswer={removeAnswer}
          addAnswer={addAnswer}
          handleQuestion={handleQuestion}
          handleAnswer={handleAnswer}
        />
      ) : (
        <CardForm
          problem={problem}
          number={number}
          onRemove={onRemove}
          handleEditable={handleEditable}
        />
      )}
    </>
  );
}

export default EditableProblem;
