import React, { useState } from "react";
import { useAuth } from "../auth/auth-context";
import Form from "react-bootstrap/Form";
import Container from "react-bootstrap/Container";
import { read as readUser } from "../user/api-user";
import { list, read as readCourse } from "../course/api-course";
import { useEffect } from "react";
import Card from "react-bootstrap/esm/Card";
import { Link, Redirect, useParams } from "react-router-dom";
import authHelpers from "../auth/auth-helpers";
import { listByUserId } from "../quiz/api-quiz";

function Warning() {
  const [data, setData] = useState({ name: "" });
  const [courses, setCourses] = useState([
    { name: "", description: "", code: "" },
  ]);
  const [quizzes, setQuizzes] = useState([{id:"", course:""}]);
  const { userId } = useParams();
  const jwt = authHelpers.isAuthenticated();

  const [values, setValues] = useState({
    title: "",
    problems: [],
    show: false,
    startAt: "",
    endAt: "",
    course: "",
  });
  const { authUser } = useAuth();

  useEffect(() => {
    const abortController = new AbortController();
    const signal = abortController.signal;

    listByUserId({ userId: authUser.user._id }, { t: jwt.token }, signal).then((data) => {
      if (data.error) {
        console.log("에러난다 ",data.error);
      } else {
        console.log("quizzes=", data);
        setQuizzes(data);
      }
    });

    readUser(authUser.user._id, { t: authUser.token }).then((res) => {
      setData(res);
    });
    list(signal).then((res) => {
      setCourses(res);
    });
    return () => {
      abortController.abort();
    };
  }, [userId]);

  const handleChange = (event) => {
    const { name, value } = event.target;
    console.log("name", name, "value", value);
    console.log("values:", values);

    if (name === "course") {
      console.log(`${name}: ${courses[value]._id}`);
      setValues({ ...values, [name]: courses[value]._id });
    } else {
      setValues({ ...values, [name]: value });
    }
  };
  return (
    <div>
      <Container className="col-sm-6 col-md-5 col-lg-4 p-5">
        <Form.Text className="text-muted">
          <h1 className="text-center mt-1 pb-3 font-italic text-danger">
            Korea University
          </h1>
          <Card className="p-3 ">
            <h4 className="card-title mb-4">응시자 정보 </h4>
            <p className="ml-2">이름 : {data.name}</p>
            <p className="ml-2">e-mail : {data.email}</p>
            <p className="ml-2">
              {" "}
              <div className="mb-2">[수강과목]</div>{" "}
              {courses.map((course) => (
                <div>
                  {course.name} ({course.description}교수님){" "}
                </div>
              ))}{" "}
            </p>
            {/* <p className="ml-2">    {courses.map((courses)=>(courses.name +':'+ courses.description))}</p> */}

            <div className="mt-3 text-left">과목을 선택하세요.</div>
            <Form.Control
              className="mb-4 mt-2"
              as="select"
              id="course"
              name="course"
              onChange={handleChange}
            >
              {courses.map((course, i) => (
                <option key={i} value={i}>
                  {course.name}
                </option>
              ))}
            </Form.Control>
            <div className="text-right">
              {/* {console.log("11111 quizzes",quizzes)} */}
              {/* <Link to={`/problems/${quizzes[0]._id}`}> Start </Link> */}
              {quizzes.map((quiz, i) => {
                // console.log("2222 i=",i)
                return (<>
                  <Link key={i} to={`/problems/${quiz._id}`}>
                <button className="btn btn-danger" > {quiz.course} </button>
                    {/* {console.log("좀 돼라",i)} */}
                  </Link>
                {/* <div> {console.log("3333quiz=",quiz)}</div> */}
                </>)
              }
              )}

              {/* <a href="#" class="card-link">Another link</a> */}
            </div>
            {/* <p>시험문제 수 :</p>
                    <p>시험 시간 : </p>
                    <p>공지 사항 : </p> */}
          </Card>
        </Form.Text>
      </Container>
    </div>
  );
}

export default Warning;
