import React, { useState, useEffect } from "react";
import { useParams } from "react-router-dom";
import { read } from "./api-quiz";
import auth from "../auth/auth-helpers";
import Problem from './Problem'

function Quiz() {
  const { quizId } = useParams();
  const [quiz, setQuiz] = useState({});

  const jwt = auth.isAuthenticated();

  useEffect(() => {
    const abortController = new AbortController();
    const signal = abortController.signal;

    read({ quizId: quizId }, { t: jwt.token }, signal).then((data) => {
      if (data.error) {
        console.log(data.error);
      } else {
        setQuiz(data);
      }
    });
    return () => {
      abortController.abort();
    };
  }, [quizId]);

  return (
    <div>
      {quiz.problems?.map((problem, i) => {
        return <Problem key={i} problem={problem} number={i+1} />;
      })}
    </div>
  );
}

export default Quiz;
