import React, { useState } from "react";
import Button from "react-bootstrap/Button";
import Form from "react-bootstrap/Form";
import Col from "react-bootstrap/Col";

function NewProblem({ addProblem }) {
  const [answers, setAnswers] = useState([""]);
  const [question, setQuestion] = useState("");

  const addAnswer = () => {
    setAnswers([...answers, ""]);
  };

  const removeAnswer = (index) => {
    const list = [...answers];
    list.splice(index, 1);
    setAnswers(list);
  };

  const handleAnswer = (event, index) => {
    const { value } = event.target;
    const list = [...answers];
    list[index] = value;
    setAnswers(list);
  };

  const handleQuestion = (event) => {
    setQuestion(event.target.value);
  };

  const clickAdd = (event) => {
    event.preventDefault();
    addProblem({ question, answers });
  };

  return (
    <div>
      <Form>
        <Form.Group controlId="question">
          <Form.Label>Question</Form.Label>
          <Form.Control
            name="question"
            as="textarea"
            rows={5}
            onChange={handleQuestion}
          />
        </Form.Group>
        <Form.Label>Answers</Form.Label>
        {answers.map((answer, index) => {
          return (
            <Form.Row key={index}>
              <Col>
                <Form.Control
                  type="text"
                  value={answer}
                  onChange={(event) => handleAnswer(event, index)}
                />
              </Col>
              <Col>
                {answers.length !== 1 && (
                  <Button onClick={removeAnswer}>Remove</Button>
                )}
                {answers.length - 1 === index && (
                  <Button onClick={addAnswer}>Add</Button>
                )}
              </Col>
            </Form.Row>
          );
        })}
        <Button onClick={clickAdd}>Add</Button>
      </Form>
    </div>
  );
}

export default NewProblem;
