import React from "react";
import { Route, Switch } from "react-router-dom";
import Signin from "./auth/Signin";
import Home from "./core/Home";
import Menu from "./core/Menu";
import NewQuiz from './quiz/NewQuiz'
import Quiz from './quiz/Quiz'
import Signup from "./user/Signup"

function MainRouter() {
  return (
    <div>
      <Menu />
      <Switch>
        <Route exact path="/">
          {/* {console.log('Home 안에서 ...')} */}
          <Home />
        </Route>
        <Route path="/signin">
          <Signin />
        </Route>
        <Route path="/signup">
          <Signup />
        </Route>
        <Route path='/quiz/new'>
          <NewQuiz />
        </Route>
        <Route path="/quiz/:quizId">
          <Quiz />
        </Route>
      </Switch>
    </div>
    // <BrowserRouter>
    // {console.log('BrowserRoter 안에서 ...')}
    // </BrowserRouter>
  );
}

export default MainRouter;
