import React, { useState } from "react"
import { useAuth } from "../auth/auth-context"
import Form from "react-bootstrap/Form";
import Container from "react-bootstrap/Container";
import { read as readUser } from '../user/api-user';
import { read as readCourse } from '../course/api-course';
import { useEffect } from "react";

function Warning() {
    const { authUser } = useAuth()
    useEffect(() => {
        readUser(authUser.user._id, { t: authUser.token }).then(res => {
            setData(res);
        })
        readCourse("5f7fc9071575948025e29ebb", { t: authUser.token }).then(res => {
            console.log(res);
            setCourse(res);
        })
    }, [])
    const [data, setData] = useState({ name: "", })
    const [course, setCourse] = useState({ name: "", description: "", code: "", })
    return (
        <div>
            <Container className="col-sm-6 col-md-5 col-lg-4 p-5">
                {console.log(data)}
                <Form.Text className="text-muted">
                    <h1 className="text-center mt-1 pb-3 font-italic text-danger">Korea University</h1>
                    <p>응시자 정보 </p>
                    <p>이름 : {data.name}</p>
                    <p>e-mail : {data.email}</p>
                    <p>응시 과목 :{course.name}</p>
                    <p>담당 교수 :{course.description}</p>
                    {/* <p>시험문제 수 :</p>
                    <p>시험 시간 : </p>
                    <p>공지 사항 : </p> */}

                </Form.Text>
            </Container>
        </div>
    )
}

export default Warning