import React, { useState } from "react";
import Button from "react-bootstrap/Button";
import Form from "react-bootstrap/Form";
import Container from "react-bootstrap/Container";
import { signin } from "./api-auth";
import auth from "./auth-helpers";
import { Redirect } from "react-router-dom";
import { useAuth } from "./auth-context";
import { Link } from "react-router-dom"

function Signin() {
  const { setAuthUser } = useAuth();
  const [values, setValues] = useState({
    email: "",
    password: "",
    error: "",
    redirect: false,
  });

  const handleChange = (name) => (event) => {
    setValues({ ...values, [name]: event.target.value });
  };

  const clickSubmit = (event) => {
    event.preventDefault();
    const user = {
      email: values.email || undefined,
      password: values.password || undefined,
    };

    signin(user).then((data) => {
      if (data.error) {
        setValues({ ...values, error: data.error });
      } else {
        auth.authenticate(data, () => {
          setAuthUser(auth.isAuthenticated());
          setValues({ ...values, error: "", redirect: true });
        });
      }
    });
  };

  if (values.redirect) {
    return <Redirect to="/" />;
  }

  return (
    <Container className="col-sm-6 col-md-5 col-lg-4 p-5">
      <h1 className="text-center mt-1 pb-3 font-italic text-danger">Korea<br />University</h1>
      <Form>
        <Form.Group controlId="email">
          <Form.Label>Email</Form.Label>
          <Form.Control
            type="email"
            placeholder="Enter email"
            onChange={handleChange("email")}
          />
          <Form.Text className="text-muted">
            We'll never share your email with anyone else.
          </Form.Text>
        </Form.Group>

        <Form.Group controlId="password">
          <Form.Label>Password</Form.Label>
          <Form.Control
            type="password"
            placeholder="Enter Password"
            onChange={handleChange("password")}
          />
        </Form.Group>

        <Button block variant="danger" type="submit" onClick={clickSubmit}>
          Sign in
        </Button>
        <Link to="/signup">
          <Button block className="text-left" variant="default">New Account</Button>
        </Link>
      </Form>
    </Container>
    
  );
}

export default Signin;
