import React, { useState, useEffect } from "react";
import { Link, useParams } from "react-router-dom";
import { read, removeProblem } from "./api-quiz";
import auth from "../auth/auth-helpers";
import Problem from './Problem'
import Button from "react-bootstrap/Button";

function Quiz() {
  const { quizId } = useParams();
  const [quiz, setQuiz] = useState({});

  const jwt = auth.isAuthenticated();

  useEffect(() => {
    const abortController = new AbortController();
    const signal = abortController.signal;

    read({ quizId: quizId }, { t: jwt.token }, signal).then((data) => {
      if (data.error) {
        console.log(data.error);
      } else {
        setQuiz(data);
      }
    });
    return () => {
      abortController.abort();
    };
  }, [quizId]);

  const handleUpdate = (index) => {
    console.log(`Quiz에서 handleUpdate ${index}번 실행`);
    console.log(`Quiz에서 handleUpdate ${JSON.stringify(quiz.problems[index])}`);
  }

  const handleRemove = (index) => {
    console.log('Quiz에서 handleRemove 실행');
    const problem = quiz.problems[index]
    console.log(problem);
    removeProblem({problemId: problem._id}, {t: jwt.token}).then(data => {
      if (data.error) {
        console.log(data.error);
      } else {
        console.log('deleted Problem:', data);
        const list = [...quiz.problems]
        list.splice(index, 1)
        setQuiz({...quiz, problems: list})
      }
    })
  }

  return (
    <div>
      <h2>제목: {quiz.title}</h2>
      {quiz.problems?.map((problem, i) => {
        return <Problem key={i} problem={problem} number={i} onUpdate={handleUpdate} onRemove={handleRemove} />;
      })}
      <Link to={`/quiz/problem/new/${quizId}`}>
        <Button>문제 추가</Button>
      </Link>
    </div>
  );
}

export default Quiz;
