import React from "react"
import Navbar from "react-bootstrap/Navbar"
import Nav from "react-bootstrap/Nav"
import NavDropdown from "react-bootstrap/NavDropdown"
import Button from "react-bootstrap/Button"
import auth from "../auth/auth-helpers"
import { Link, useHistory } from "react-router-dom"
import { useAuth } from "../auth/auth-context"

function Menu() {
  const { authUser, setAuthUser } = useAuth()
  const history = useHistory()

  return (
    <Navbar sticky="top" bg="dark" variant="dark" expand="sm">
      <Navbar.Brand href="/">
        <i className="fas fa-diagnoses fa-2x"></i>
      </Navbar.Brand>
      <Navbar.Toggle aria-controls="basic-navbar-nav" />
      <Navbar.Collapse id="basic-navbar-nav">
        <Nav className="mr-auto">
          <Nav.Link href="/">Home</Nav.Link>
          {authUser && <Nav.Link as={Link} to={`/quiz/by/${authUser.user._id}`}>Quizzes</Nav.Link>}
          <Nav.Link href="/quiz/new">New Quiz</Nav.Link>
          <NavDropdown title="Dropdown" id="basic-nav-dropdown">
            <NavDropdown.Item href="#action/3.1">Action</NavDropdown.Item>
            <NavDropdown.Item href="#action/3.2">
              Another action
            </NavDropdown.Item>
            <NavDropdown.Item href="#action/3.3">Something</NavDropdown.Item>
            <NavDropdown.Divider />
            <NavDropdown.Item href="#action/3.4">
              Separated link
            </NavDropdown.Item>
          </NavDropdown>
        </Nav>
        {authUser ? (
          <Button
            onClick={() =>
              auth.clearJwt(() => {
                history.push("/")
                setAuthUser(false)
              })
            }
          >
            Sign out
          </Button>
        ) : (
            <>
              <Link to="/signin">
                <Button>Sign in</Button>
              </Link>
              <Link to="/signup">
                <Button>Sign up</Button>
              </Link>
            </>
          )}
      </Navbar.Collapse>
    </Navbar>
  )
}

export default Menu
