import express from 'express'
import bodyParser from 'body-parser'
import userRoutes from './user/user.routes.js'

const app = express()

app.use(bodyParser.json())
app.use(bodyParser.urlencoded({ extended: true }))

app.use('/', userRoutes)

app.use((err, req, res, next) => {
  if (err.name === 'UnauthorizedError') {
    res.status(401).json({
      error: err.name + ': ' + err.message
    })
  } else if (err) {
    res.status(400).json({
      error: err.name + ': ' + err.message
    })
    console.log(err)
  }
})

export default app