const getErrorMessage = (err) => {
  let message = ''
  // console.log('error in getErrorMessage', err)
  if (err.code) {
    switch (err.code) {
      case 11000:
      case 11001:
        message = getUniqueErrorMessage(err)
        break
      default:
        message = 'Something went wrong'
    }
  } else if (err._message) {
    message = err._message
  }
  return message
}

const getUniqueErrorMessage = (err) => {
  let output
  // console.log('error in getUniqueErrormessage', err)
  try {
    let fieldName = err.message.substring(err.message.lastIndexOf('.$') + 2,
      err.message.lastIndexOf('_1'))
    output = fieldName.charAt(0).toUpperCase() + fieldName.slice(1) + ' already exists'
  } catch (error) {
    output = 'Unique field already exists'
  }
  return output
}

export default { getErrorMessage }